/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store;

import com.unity3d.ads.core.extensions.JsonSerializableExtensionsKt;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.StoreWebViewEventSender;
import com.unity3d.services.store.gpbl.BillingResultResponseCode;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseHistoryRecordBridge;
import com.unity3d.services.store.gpbl.bridges.SkuDetailsBridge;
import com.unity3d.services.store.gpbl.listeners.StoreEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0012H\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0012H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unity3d/services/store/WebViewStoreEventListener;", "Lcom/unity3d/services/store/gpbl/listeners/StoreEventListener;", "operationId", "", "storeWebViewEventSender", "Lcom/unity3d/services/store/StoreWebViewEventSender;", "isLifecycleListener", "", "(ILcom/unity3d/services/store/StoreWebViewEventSender;Z)V", "getOperationId", "()I", "onBillingServiceDisconnected", "", "onBillingSetupFinished", "billingResult", "Lcom/unity3d/services/store/gpbl/bridges/BillingResultBridge;", "onPurchaseHistoryUpdated", "purchaseHistoryRecordList", "", "Lcom/unity3d/services/store/gpbl/bridges/PurchaseHistoryRecordBridge;", "onPurchaseResponse", "purchases", "Lcom/unity3d/services/store/gpbl/bridges/PurchaseBridge;", "onPurchaseUpdated", "onSkuDetailsUpdated", "skuDetailsList", "Lcom/unity3d/services/store/gpbl/bridges/SkuDetailsBridge;", "triggerFeatureSupported", "featureSupported", "triggerIsAlreadyInitialized", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nWebViewStoreEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewStoreEventListener.kt\ncom/unity3d/services/store/WebViewStoreEventListener\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,110:1\n37#2,2:111\n37#2,2:113\n*S KotlinDebug\n*F\n+ 1 WebViewStoreEventListener.kt\ncom/unity3d/services/store/WebViewStoreEventListener\n*L\n85#1:111,2\n88#1:113,2\n*E\n"})
public final class WebViewStoreEventListener
implements StoreEventListener {
    private final int operationId;
    @NotNull
    private final StoreWebViewEventSender storeWebViewEventSender;
    private final boolean isLifecycleListener;

    public WebViewStoreEventListener(int operationId, @NotNull StoreWebViewEventSender storeWebViewEventSender, boolean isLifecycleListener) {
        Intrinsics.checkNotNullParameter((Object)storeWebViewEventSender, (String)"storeWebViewEventSender");
        this.operationId = operationId;
        this.storeWebViewEventSender = storeWebViewEventSender;
        this.isLifecycleListener = isLifecycleListener;
    }

    public /* synthetic */ WebViewStoreEventListener(int n, StoreWebViewEventSender storeWebViewEventSender, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, storeWebViewEventSender, bl);
    }

    @Override
    public int getOperationId() {
        return this.operationId;
    }

    @Override
    public void triggerIsAlreadyInitialized() {
        Object[] objectArray = new Object[]{BillingResultResponseCode.OK.getResponseCode()};
        this.storeWebViewEventSender.send(StoreEvent.INITIALIZATION_REQUEST_RESULT, objectArray);
    }

    @Override
    public void triggerFeatureSupported(int featureSupported) {
        Object[] objectArray = new Object[]{this.getOperationId(), featureSupported};
        this.storeWebViewEventSender.send(StoreEvent.IS_FEATURE_SUPPORTED_REQUEST_RESULT, objectArray);
    }

    @Override
    public void onBillingSetupFinished(@NotNull BillingResultBridge billingResult) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        if (billingResult.getResponseCode() == BillingResultResponseCode.OK) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)((Object)billingResult.getResponseCode()), (String)"billingResult.responseCode");
            this.storeWebViewEventSender.send(StoreEvent.INITIALIZATION_REQUEST_RESULT, objectArray);
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)((Object)billingResult.getResponseCode()), (String)"billingResult.responseCode");
            this.storeWebViewEventSender.send(StoreEvent.INITIALIZATION_REQUEST_FAILED, objectArray);
        }
    }

    @Override
    public void onBillingServiceDisconnected() {
        this.storeWebViewEventSender.send(StoreEvent.DISCONNECTED_RESULT, new Object[0]);
    }

    @Override
    public void onPurchaseHistoryUpdated(@NotNull BillingResultBridge billingResult, @Nullable List<? extends PurchaseHistoryRecordBridge> purchaseHistoryRecordList) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        Object[] objectArray = new Object[3];
        objectArray[0] = this.getOperationId();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)billingResult.getResponseCode()), (String)"billingResult.responseCode");
        JSONArray jSONArray = purchaseHistoryRecordList;
        if (jSONArray == null || (jSONArray = JsonSerializableExtensionsKt.toJsonArray(jSONArray)) == null) {
            jSONArray = new JSONArray();
        }
        objectArray[2] = jSONArray;
        this.storeWebViewEventSender.send(StoreEvent.PURCHASE_HISTORY_LIST_REQUEST_RESULT, objectArray);
    }

    @Override
    public void onSkuDetailsUpdated(@NotNull BillingResultBridge billingResult, @Nullable List<? extends SkuDetailsBridge> skuDetailsList) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        Object[] objectArray = new Object[2];
        objectArray[0] = this.getOperationId();
        JSONArray jSONArray = skuDetailsList;
        if (jSONArray == null || (jSONArray = JsonSerializableExtensionsKt.toJsonArray(jSONArray)) == null) {
            jSONArray = new JSONArray();
        }
        objectArray[1] = jSONArray;
        this.storeWebViewEventSender.send(StoreEvent.SKU_DETAILS_LIST_REQUEST_RESULT, objectArray);
    }

    @Override
    public void onPurchaseResponse(@NotNull BillingResultBridge billingResult, @Nullable List<? extends PurchaseBridge> purchases) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.getOperationId() != -1) {
            params.add(this.getOperationId());
        }
        if (billingResult.getResponseCode() == BillingResultResponseCode.OK) {
            JSONArray jSONArray = purchases;
            if (jSONArray == null || (jSONArray = JsonSerializableExtensionsKt.toJsonArray(jSONArray)) == null) {
                jSONArray = new JSONArray();
            }
            JSONArray purchasesJson = jSONArray;
            params.add(purchasesJson);
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            this.storeWebViewEventSender.send(this.isLifecycleListener ? StoreEvent.PURCHASES_ON_RESUME_RESULT : StoreEvent.PURCHASES_REQUEST_RESULT, Arrays.copyOf(objectArray, objectArray.length));
        } else {
            params.add((Object)billingResult.getResponseCode());
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            this.storeWebViewEventSender.send(this.isLifecycleListener ? StoreEvent.PURCHASES_ON_RESUME_ERROR : StoreEvent.PURCHASES_REQUEST_ERROR, Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    @Override
    public void onPurchaseUpdated(@NotNull BillingResultBridge billingResult, @Nullable List<? extends PurchaseBridge> purchases) {
        Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
        if (billingResult.getResponseCode() == BillingResultResponseCode.OK) {
            Object[] objectArray = new Object[1];
            JSONArray jSONArray = purchases;
            if (jSONArray == null || (jSONArray = JsonSerializableExtensionsKt.toJsonArray(jSONArray)) == null) {
                jSONArray = new JSONArray();
            }
            objectArray[0] = jSONArray;
            this.storeWebViewEventSender.send(StoreEvent.PURCHASES_UPDATED_RESULT, objectArray);
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)((Object)billingResult.getResponseCode()), (String)"billingResult.responseCode");
            this.storeWebViewEventSender.send(StoreEvent.PURCHASES_UPDATED_ERROR, objectArray);
        }
    }
}

