/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.api;

import android.os.Build;
import com.unity3d.services.ads.video.VideoPlayerError;
import com.unity3d.services.ads.video.VideoPlayerEvent;
import com.unity3d.services.ads.video.VideoPlayerView;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class VideoPlayer {
    private static VideoPlayerView _videoPlayerView;

    public static void setVideoPlayerView(VideoPlayerView videoPlayerView) {
        _videoPlayerView = videoPlayerView;
    }

    public static VideoPlayerView getVideoPlayerView() {
        return _videoPlayerView;
    }

    @WebViewExposed
    public static void setProgressEventInterval(final Integer milliseconds, WebViewCallback callback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().setProgressEventInterval(milliseconds);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getProgressEventInterval(WebViewCallback callback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(VideoPlayer.getVideoPlayerView().getProgressEventInterval());
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void prepare(String url, Double initialVolume, WebViewCallback callback) {
        VideoPlayer.prepare(url, initialVolume, 0, callback);
    }

    @WebViewExposed
    public static void prepare(final String url, final Double initialVolume, final Integer timeout, WebViewCallback callback) {
        DeviceLog.debug("Preparing video for playback: " + url);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().prepare(url, initialVolume.floatValue(), timeout);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(url);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void play(WebViewCallback callback) {
        DeviceLog.debug("Starting playback of prepared video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().play();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void pause(WebViewCallback callback) {
        DeviceLog.debug("Pausing current video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().pause();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void stop(WebViewCallback callback) {
        DeviceLog.debug("Stopping current video");
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().stop();
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void seekTo(final Integer time, WebViewCallback callback) {
        DeviceLog.debug("Seeking video to time: " + time);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.getVideoPlayerView() != null) {
                    VideoPlayer.getVideoPlayerView().seekTo(time);
                }
            }
        });
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(new Object[0]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getCurrentPosition(WebViewCallback callback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(VideoPlayer.getVideoPlayerView().getCurrentPosition());
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getVolume(WebViewCallback callback) {
        if (VideoPlayer.getVideoPlayerView() != null) {
            callback.invoke(Float.valueOf(VideoPlayer.getVideoPlayerView().getVolume()));
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setVolume(Double volume, WebViewCallback callback) {
        DeviceLog.debug("Setting video volume: " + volume);
        if (VideoPlayer.getVideoPlayerView() != null) {
            VideoPlayer.getVideoPlayerView().setVolume(Float.valueOf(volume.floatValue()));
            callback.invoke(volume);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void setInfoListenerEnabled(boolean enabled, WebViewCallback callback) {
        if (Build.VERSION.SDK_INT > 16) {
            if (VideoPlayer.getVideoPlayerView() != null) {
                VideoPlayer.getVideoPlayerView().setInfoListenerEnabled(enabled);
                callback.invoke(new Object[]{WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.INFO, enabled});
            } else {
                callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
            }
        } else {
            callback.error(VideoPlayerError.API_LEVEL_ERROR, Build.VERSION.SDK_INT, enabled);
        }
    }

    @WebViewExposed
    public static void getVideoViewRectangle(WebViewCallback callback) {
        VideoPlayerView view = VideoPlayer.getVideoPlayerView();
        if (view != null) {
            int[] rectangle = view.getVideoViewRectangle();
            callback.invoke(rectangle[0], rectangle[1], rectangle[2], rectangle[3]);
        } else {
            callback.error(VideoPlayerError.VIDEOVIEW_NULL, new Object[0]);
        }
    }
}

