/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.adunit;

import com.unity3d.services.ads.adunit.IAdUnitViewHandler;
import com.unity3d.services.ads.adunit.IAdUnitViewHandlerFactory;
import com.unity3d.services.ads.configuration.IAdsModuleConfiguration;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import java.util.Map;

public class AdUnitViewHandlerFactory
implements IAdUnitViewHandlerFactory {
    @Override
    public IAdUnitViewHandler createViewHandler(String name) {
        if (WebViewApp.getCurrentApp() != null) {
            Class[] list;
            Configuration configuration = WebViewApp.getCurrentApp().getConfiguration();
            for (Class moduleClass : list = configuration.getModuleConfigurationList()) {
                Map<String, Class> adUnitViewHandlers;
                IModuleConfiguration moduleConfig = configuration.getModuleConfiguration(moduleClass);
                if (!(moduleConfig instanceof IAdsModuleConfiguration) || (adUnitViewHandlers = ((IAdsModuleConfiguration)moduleConfig).getAdUnitViewHandlers()) == null || !adUnitViewHandlers.containsKey(name)) continue;
                IAdUnitViewHandler viewHandler = null;
                try {
                    viewHandler = (IAdUnitViewHandler)adUnitViewHandlers.get(name).newInstance();
                }
                catch (Exception e) {
                    DeviceLog.error("Error creating view: " + name);
                }
                return viewHandler;
            }
        }
        return null;
    }
}

