package com.unity3d.services.store.core

import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler
import com.unity3d.services.store.StoreError
import com.unity3d.services.store.StoreEvent
import org.json.JSONException
import java.lang.reflect.InvocationTargetException

class StoreExceptionHandler(private val _webViewErrorHandler: WebViewErrorHandler) {
    fun handleStoreException(storeEvent: StoreEvent, operationId: Int, exception: Exception) {
        sendErrorToWebView(storeEvent, getStoreError(exception), operationId, exception)
    }

    private fun sendErrorToWebView(
        storeEvent: StoreEvent,
        storeError: StoreError,
        operationId: Int,
        exception: Exception
    ) {
        _webViewErrorHandler.handleError(
            StoreWebViewError(
                storeEvent,
                exception.message,
                operationId,
                storeError,
                exception.message
            )
        )
    }

    private fun getStoreError(exception: Exception): StoreError {
        var result = StoreError.UNKNOWN_ERROR
        if (exception is NoSuchMethodException) {
            result = StoreError.NO_SUCH_METHOD
        } else if (exception is IllegalAccessException) {
            result = StoreError.ILLEGAL_ACCESS
        } else if (exception is JSONException) {
            result = StoreError.JSON_ERROR
        } else if (exception is InvocationTargetException) {
            result = StoreError.INVOCATION_TARGET
        } else if (exception is ClassNotFoundException) {
            result = StoreError.CLASS_NOT_FOUND
        }
        return result
    }
}
