package com.unity3d.services.store.core

import com.unity3d.ads.core.configuration.AlternativeFlowReader
import com.unity3d.services.store.StoreWebViewEventSender
import com.unity3d.services.store.WebViewStoreEventListener
import com.unity3d.services.store.gpbl.listeners.StoreEventListener

class StoreEventListenerFactory (
    @Suppress("unused") // TODO(lmoreault): Will be used in subsequent PR
    private val alternativeFlowReader: AlternativeFlowReader,
    private val storeWebViewEventSender: StoreWebViewEventSender
) {
    operator fun invoke(operationId: Int = -1, isLifecycleListener: Boolean = false): StoreEventListener {
        // if (alternativeFlowReader()) {
            // Here, we'll return the new listener that will post transaction to our internal repository
            // WebViewStoreEventListener(operationId, storeWebViewEventSender, isLifecycleListener)
        // }
        return WebViewStoreEventListener(operationId, storeWebViewEventSender, isLifecycleListener)
    }
}