package com.unity3d.ads.core.configuration

import com.unity3d.services.core.misc.JsonStorage

class AlternativeFlowReader(jsonStorage: JsonStorage) : MetadataReader<Boolean>(jsonStorage, ALTERNATIVE_FLOW_ENABLED_KEY) {
    operator fun invoke(): Boolean {
        return jsonStorage.get(ALTERNATIVE_FLOW_ENABLED_KEY)?.let {
            when (it) {
                is String -> it.toBoolean()
                is Boolean -> it
                else -> false
            }
        } ?: false
    }

    companion object {
        const val ALTERNATIVE_FLOW_ENABLED_KEY = "adsGateway.value"
    }
}