package com.unity3d.ads.adplayer

import kotlinx.coroutines.CompletableDeferred
import kotlinx.coroutines.Deferred

class Invocation(
    val location: ExposedFunctionLocation,
    val parameters: Array<Any>,
) {
    private val _isHandled = CompletableDeferred<Unit>()
    val isHandled: Deferred<Unit>
        get() = _isHandled

    private val completableDeferred = CompletableDeferred<Any>()

    suspend fun handle(handler: suspend () -> Any = {}) {
        _isHandled.complete(Unit)

        try {
            val result = handler()
            completableDeferred.complete(result)
        } catch (e: Throwable) {
            completableDeferred.completeExceptionally(e)
        }
    }

    suspend fun getResult() = completableDeferred.await()
}