package com.unity3d.ads.adplayer

import android.content.Context
import android.webkit.WebResourceResponse
import androidx.webkit.WebViewAssetLoader
import com.unity3d.services.UnityAdsConstants
import com.unity3d.services.UnityAdsConstants.DefaultUrls.AD_ASSET_PATH
import com.unity3d.services.core.log.DeviceLog
import java.io.File

fun interface GetAdAssetLoader : () -> WebViewAssetLoader

fun provideGetAdCacheAssetLoader(context: Context) = GetAdAssetLoader {
    WebViewAssetLoader.Builder()
        .addPathHandler(AD_ASSET_PATH) { path: String ->
            try {
                val file = File(context.filesDir, "unityads/$path")
                val inputStream = file.inputStream()
                WebResourceResponse(guessMimeType(path), null, inputStream)
            } catch (e: Exception) {
                DeviceLog.debug("Ad Asset not found: %s", path)
                null
            }
        }
        .setDomain(UnityAdsConstants.DefaultUrls.ASSET_DOMAIN)
        .build()
}