/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.properties;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.unity3d.services.core.log.DeviceLog;
import java.io.ByteArrayInputStream;
import java.lang.ref.WeakReference;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class ClientProperties {
    private static final X500Principal DEBUG_CERT = new X500Principal("CN=Android Debug,O=Android,C=US");
    private static WeakReference<Activity> _activity;
    private static Context _applicationContext;
    private static Application _application;
    private static String _gameId;

    public static Activity getActivity() {
        return (Activity)_activity.get();
    }

    public static void setActivity(Activity activity) {
        _activity = new WeakReference<Activity>(activity);
    }

    public static Context getApplicationContext() {
        return _applicationContext;
    }

    public static void setApplicationContext(Context context) {
        _applicationContext = context;
    }

    public static Application getApplication() {
        return _application;
    }

    public static void setApplication(Application application) {
        _application = application;
    }

    public static String getGameId() {
        return _gameId;
    }

    public static void setGameId(String gameId) {
        _gameId = gameId;
    }

    public static String getAppName() {
        if (_applicationContext == null) {
            return "";
        }
        return _applicationContext.getPackageName();
    }

    public static String getAppVersion() {
        String pkgName = ClientProperties.getApplicationContext().getPackageName();
        PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
        try {
            if (pm.getPackageInfo((String)pkgName, (int)0).versionName == null) {
                return "FakeVersionName";
            }
            return pm.getPackageInfo((String)pkgName, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            DeviceLog.exception("Error getting package info", (Exception)((Object)e));
            return null;
        }
    }

    public static boolean isAppDebuggable() {
        boolean debuggable = false;
        boolean couldNotGetApplicationInfo = false;
        if (ClientProperties.getApplicationContext() == null) {
            return false;
        }
        PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
        String pkgName = ClientProperties.getApplicationContext().getPackageName();
        try {
            ApplicationInfo appinfo = pm.getApplicationInfo(pkgName, 0);
            if (0 != (appinfo.flags &= 2)) {
                debuggable = true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            DeviceLog.exception("Could not find name", (Exception)((Object)e));
            couldNotGetApplicationInfo = true;
        }
        if (couldNotGetApplicationInfo) {
            try {
                Signature[] signatures;
                PackageInfo pinfo = pm.getPackageInfo(pkgName, 64);
                for (Signature signature : signatures = pinfo.signatures) {
                    ByteArrayInputStream stream;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(stream = new ByteArrayInputStream(signature.toByteArray()));
                    debuggable = cert.getSubjectX500Principal().equals(DEBUG_CERT);
                    if (!debuggable) {
                        continue;
                    }
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                DeviceLog.exception("Could not find name", (Exception)((Object)e));
            }
            catch (CertificateException e) {
                DeviceLog.exception("Certificate exception", e);
            }
        }
        return debuggable;
    }
}

