/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.unity3d.services.core.log.DeviceLog;
import java.lang.reflect.Method;

public class ViewUtilities {
    public static void removeViewFromParent(View view) {
        if (view != null && view.getParent() != null) {
            try {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            catch (Exception e) {
                DeviceLog.exception("Error while removing view from it's parent", e);
            }
        }
    }

    public static void setBackground(View view, Drawable drawable) {
        Class<View> cl = View.class;
        String methodName = "setBackground";
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            methodName = "setBackgroundDrawable";
        }
        try {
            Method setBackground = cl.getMethod(methodName, Drawable.class);
            setBackground.invoke((Object)view, drawable);
        }
        catch (Exception e) {
            DeviceLog.exception("Couldn't run" + methodName, e);
        }
    }

    public static float dpFromPx(Context context, float px) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static float pxFromDp(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }
}

