/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.unity3d.services.core.log.DeviceLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@TargetApi(value=9)
public class OpenAdvertisingId {
    private static final String HW_OPEN_ADVERTISING_ID_SERVICE_NAME = "com.uodis.opendevice.aidl.OpenDeviceIdentifierService";
    private static final String HW_DEVICE_NAME = "HUAWEI";
    private static OpenAdvertisingId instance = null;
    private String openAdvertisingIdentifier = null;
    private boolean limitedOpenAdTracking = false;

    private static OpenAdvertisingId getInstance() {
        if (instance == null) {
            instance = new OpenAdvertisingId();
        }
        return instance;
    }

    public static void init(Context context) {
        if (Build.MANUFACTURER.toUpperCase().equals(HW_DEVICE_NAME)) {
            OpenAdvertisingId.getInstance().fetchOAId(context);
        }
    }

    public static String getOpenAdvertisingTrackingId() {
        return OpenAdvertisingId.getInstance().openAdvertisingIdentifier;
    }

    public static boolean getLimitedOpenAdTracking() {
        return OpenAdvertisingId.getInstance().limitedOpenAdTracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchOAId(Context context) {
        HWAdvertisingServiceConnection connection = new HWAdvertisingServiceConnection();
        Intent localIntent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        localIntent.setPackage("com.huawei.hwid");
        try {
            if (!context.bindService(localIntent, (ServiceConnection)connection, 1)) {
                return;
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Couldn't bind to identifier service intent", e);
            return;
        }
        try {
            HWAdvertisingInfo advertisingInfo = HWAdvertisingInfo.HWAdvertisingInfoBinder.create(connection.getBinder());
            this.openAdvertisingIdentifier = advertisingInfo.getId();
            this.limitedOpenAdTracking = advertisingInfo.getEnabled(true);
        }
        catch (Exception e) {
            DeviceLog.exception("Couldn't get openAdvertising info", e);
        }
        finally {
            context.unbindService((ServiceConnection)connection);
        }
    }

    private class HWAdvertisingServiceConnection
    implements ServiceConnection {
        boolean _consumed = false;
        private final BlockingQueue<IBinder> _binderQueue = new LinkedBlockingQueue<IBinder>();

        private HWAdvertisingServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this._binderQueue.put(service);
            }
            catch (InterruptedException localInterruptedException) {
                DeviceLog.debug("Couldn't put service to binder que");
                Thread.currentThread().interrupt();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder getBinder() throws InterruptedException {
            if (this._consumed) {
                throw new IllegalStateException();
            }
            this._consumed = true;
            return this._binderQueue.take();
        }
    }

    private static interface HWAdvertisingInfo
    extends IInterface {
        public String getId() throws RemoteException;

        public boolean getEnabled(boolean var1) throws RemoteException;

        public static abstract class HWAdvertisingInfoBinder
        extends Binder
        implements HWAdvertisingInfo {
            public static HWAdvertisingInfo create(IBinder binder) {
                if (binder == null) {
                    return null;
                }
                IInterface localIInterface = binder.queryLocalInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                if (localIInterface != null && localIInterface instanceof HWAdvertisingInfo) {
                    return (HWAdvertisingInfo)localIInterface;
                }
                return new HWAdvertisingInfoImplementation(binder);
            }

            public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                switch (code) {
                    case 1: {
                        data.enforceInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        String str1 = this.getId();
                        reply.writeNoException();
                        reply.writeString(str1);
                        return true;
                    }
                    case 2: {
                        data.enforceInterface(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        boolean bool1 = 0 != data.readInt();
                        boolean bool2 = this.getEnabled(bool1);
                        reply.writeNoException();
                        reply.writeInt(bool2 ? 1 : 0);
                        return true;
                    }
                }
                return super.onTransact(code, data, reply, flags);
            }

            private static class HWAdvertisingInfoImplementation
            implements HWAdvertisingInfo {
                private final IBinder _binder;

                HWAdvertisingInfoImplementation(IBinder binder) {
                    this._binder = binder;
                }

                public IBinder asBinder() {
                    return this._binder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String getId() throws RemoteException {
                    String str;
                    Parcel localParcel1 = Parcel.obtain();
                    Parcel localParcel2 = Parcel.obtain();
                    try {
                        localParcel1.writeInterfaceToken(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        this._binder.transact(1, localParcel1, localParcel2, 0);
                        localParcel2.readException();
                        str = localParcel2.readString();
                    }
                    finally {
                        localParcel2.recycle();
                        localParcel1.recycle();
                    }
                    return str;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean getEnabled(boolean paramBoolean) throws RemoteException {
                    boolean bool;
                    Parcel localParcel1 = Parcel.obtain();
                    Parcel localParcel2 = Parcel.obtain();
                    try {
                        localParcel1.writeInterfaceToken(OpenAdvertisingId.HW_OPEN_ADVERTISING_ID_SERVICE_NAME);
                        localParcel1.writeInt(paramBoolean ? 1 : 0);
                        this._binder.transact(2, localParcel1, localParcel2, 0);
                        localParcel2.readException();
                        bool = 0 != localParcel2.readInt();
                    }
                    finally {
                        localParcel2.recycle();
                        localParcel1.recycle();
                    }
                    return bool;
                }
            }
        }
    }
}

