/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.webplayer;

import java.util.HashMap;
import org.json.JSONObject;

public class WebPlayerSettingsCache {
    private static WebPlayerSettingsCache instance;
    private HashMap<String, JSONObject> _webSettings = new HashMap();
    private HashMap<String, JSONObject> _webPlayerSettings = new HashMap();
    private HashMap<String, JSONObject> _webPlayerEventSettings = new HashMap();

    public static WebPlayerSettingsCache getInstance() {
        if (instance == null) {
            instance = new WebPlayerSettingsCache();
        }
        return instance;
    }

    public synchronized void addWebSettings(String viewId, JSONObject webSettings) {
        this._webSettings.put(viewId, webSettings);
    }

    public synchronized void removeWebSettings(String viewId) {
        if (this._webSettings.containsKey(viewId)) {
            this._webSettings.remove(viewId);
        }
    }

    public synchronized JSONObject getWebSettings(String viewId) {
        if (this._webSettings.containsKey(viewId)) {
            return this._webSettings.get(viewId);
        }
        return new JSONObject();
    }

    public synchronized void addWebPlayerSettings(String viewId, JSONObject webPlayerSettings) {
        this._webPlayerSettings.put(viewId, webPlayerSettings);
    }

    public synchronized void removeWebPlayerSettings(String viewId) {
        if (this._webPlayerSettings.containsKey(viewId)) {
            this._webPlayerSettings.remove(viewId);
        }
    }

    public synchronized JSONObject getWebPlayerSettings(String viewId) {
        if (this._webPlayerSettings.containsKey(viewId)) {
            return this._webPlayerSettings.get(viewId);
        }
        return new JSONObject();
    }

    public synchronized void addWebPlayerEventSettings(String viewId, JSONObject webPlayerEventSettings) {
        this._webPlayerEventSettings.put(viewId, webPlayerEventSettings);
    }

    public synchronized void removeWebPlayerEventSettings(String viewId) {
        if (this._webPlayerEventSettings.containsKey(viewId)) {
            this._webPlayerEventSettings.remove(viewId);
        }
    }

    public synchronized JSONObject getWebPlayerEventSettings(String viewId) {
        if (this._webPlayerEventSettings.containsKey(viewId)) {
            return this._webPlayerEventSettings.get(viewId);
        }
        return new JSONObject();
    }
}

