/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.adunit;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.unity3d.services.ads.adunit.IAdUnitActivity;
import com.unity3d.services.ads.adunit.IAdUnitViewHandler;
import com.unity3d.services.ads.api.VideoPlayer;
import com.unity3d.services.ads.video.VideoPlayerView;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.ViewUtilities;

public class VideoPlayerHandler
implements IAdUnitViewHandler {
    private RelativeLayout _videoContainer;
    private VideoPlayerView _videoView;

    @Override
    public boolean create(IAdUnitActivity activity) {
        DeviceLog.entered();
        if (this._videoContainer == null) {
            this._videoContainer = new RelativeLayout(activity.getContext());
        }
        if (this._videoView == null) {
            this._videoView = new VideoPlayerView(activity.getContext());
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(13);
            this._videoView.setLayoutParams((ViewGroup.LayoutParams)params);
            this._videoContainer.addView((View)this._videoView);
            VideoPlayer.setVideoPlayerView(this._videoView);
        }
        return true;
    }

    @Override
    public boolean destroy() {
        DeviceLog.entered();
        if (this._videoView != null) {
            this._videoView.stopVideoProgressTimer();
            this._videoView.stopPlayback();
            ViewUtilities.removeViewFromParent((View)this._videoView);
            if (((Object)((Object)this._videoView)).equals((Object)VideoPlayer.getVideoPlayerView())) {
                VideoPlayer.setVideoPlayerView(null);
            }
            this._videoView = null;
        }
        if (this._videoContainer != null) {
            ViewUtilities.removeViewFromParent((View)this._videoContainer);
            this._videoContainer = null;
        }
        return true;
    }

    @Override
    public View getView() {
        return this._videoContainer;
    }

    @Override
    public void onCreate(IAdUnitActivity activity, Bundle savedInstanceState) {
        this.create(activity);
    }

    @Override
    public void onStart(IAdUnitActivity activity) {
    }

    @Override
    public void onStop(IAdUnitActivity activity) {
    }

    @Override
    public void onResume(IAdUnitActivity activity) {
    }

    @Override
    public void onPause(IAdUnitActivity activity) {
        this.destroy();
    }

    @Override
    public void onDestroy(IAdUnitActivity activity) {
    }
}

