/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.core;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.gpbl.StoreBilling;
import com.unity3d.services.store.listeners.PurchasesResponseListener;
import java.util.ArrayList;

public class StoreLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    private final ArrayList<String> _purchaseTypes;
    private final StoreBilling _storeBilling;
    private final PurchasesResponseListener _purchaseResponseListener;

    public StoreLifecycleListener(ArrayList<String> purchaseTypes, StoreBilling storeBilling) {
        this._purchaseTypes = purchaseTypes;
        this._storeBilling = storeBilling;
        this._purchaseResponseListener = new PurchasesResponseListener(StoreEvent.PURCHASES_ON_RESUME_RESULT, StoreEvent.PURCHASES_ON_RESUME_ERROR);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        try {
            for (String purchaseType : this._purchaseTypes) {
                this._storeBilling.getPurchases(purchaseType, this._purchaseResponseListener);
            }
        }
        catch (ClassNotFoundException exception) {
            DeviceLog.warning("Couldn't fetch purchases onActivityResumed. " + exception.getMessage());
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

