/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.domain.task;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ErrorState;
import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.domain.task.BaseParams;
import com.unity3d.services.core.domain.task.InitializationException;
import com.unity3d.services.core.domain.task.MetricTask;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/unity3d/services/core/domain/task/InitializeStateCreate;", "Lcom/unity3d/services/core/domain/task/MetricTask;", "Lcom/unity3d/services/core/domain/task/InitializeStateCreate$Params;", "Lcom/unity3d/services/core/configuration/Configuration;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "(Lcom/unity3d/services/core/domain/ISDKDispatchers;)V", "doWork", "params", "(Lcom/unity3d/services/core/domain/task/InitializeStateCreate$Params;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMetricName", "", "Params", "unity-ads_release"})
public final class InitializeStateCreate
extends MetricTask<Params, Configuration> {
    @NotNull
    private final ISDKDispatchers dispatchers;

    public InitializeStateCreate(@NotNull ISDKDispatchers dispatchers) {
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        this.dispatchers = dispatchers;
    }

    @Override
    @NotNull
    public String getMetricName() {
        return this.getMetricNameForInitializeTask("create_web_view");
    }

    @Override
    @Nullable
    public Object doWork(@NotNull Params params, @NotNull Continuation<? super Configuration> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Configuration>, Object>(params, null){
            int label;
            final /* synthetic */ Params $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ErrorState errorState;
                        ResultKt.throwOnFailure((Object)object);
                        DeviceLog.debug("Unity Ads init: creating webapp");
                        Configuration configuration = this.$params.getConfig();
                        configuration.setWebViewData(this.$params.getWebViewData());
                        try {
                            errorState = WebViewApp.create(configuration, false);
                        }
                        catch (IllegalThreadStateException e) {
                            DeviceLog.exception("Illegal Thread", e);
                            throw new InitializationException(ErrorState.CreateWebApp, e, configuration);
                        }
                        ErrorState createErrorState = errorState;
                        if (createErrorState != null) {
                            String errorMessage = "Unity Ads WebApp creation failed";
                            if (WebViewApp.getCurrentApp().getWebAppFailureMessage() != null) {
                                errorMessage = WebViewApp.getCurrentApp().getWebAppFailureMessage();
                            }
                            DeviceLog.error(errorMessage);
                            throw new InitializationException(createErrorState, new Exception(errorMessage), configuration);
                        }
                        return configuration;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Configuration> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/unity3d/services/core/domain/task/InitializeStateCreate$Params;", "Lcom/unity3d/services/core/domain/task/BaseParams;", "config", "Lcom/unity3d/services/core/configuration/Configuration;", "webViewData", "", "(Lcom/unity3d/services/core/configuration/Configuration;Ljava/lang/String;)V", "getConfig", "()Lcom/unity3d/services/core/configuration/Configuration;", "getWebViewData", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "unity-ads_release"})
    public static final class Params
    implements BaseParams {
        @NotNull
        private final Configuration config;
        @NotNull
        private final String webViewData;

        public Params(@NotNull Configuration config2, @NotNull String webViewData2) {
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)webViewData2, (String)"webViewData");
            this.config = config2;
            this.webViewData = webViewData2;
        }

        @NotNull
        public final Configuration getConfig() {
            return this.config;
        }

        @NotNull
        public final String getWebViewData() {
            return this.webViewData;
        }

        @NotNull
        public final Configuration component1() {
            return this.config;
        }

        @NotNull
        public final String component2() {
            return this.webViewData;
        }

        @NotNull
        public final Params copy(@NotNull Configuration config2, @NotNull String webViewData2) {
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            Intrinsics.checkNotNullParameter((Object)webViewData2, (String)"webViewData");
            return new Params(config2, webViewData2);
        }

        public static /* synthetic */ Params copy$default(Params params, Configuration configuration, String string, int n, Object object) {
            if ((n & 1) != 0) {
                configuration = params.config;
            }
            if ((n & 2) != 0) {
                string = params.webViewData;
            }
            return params.copy(configuration, string);
        }

        @NotNull
        public String toString() {
            return "Params(config=" + this.config + ", webViewData=" + this.webViewData + ')';
        }

        public int hashCode() {
            int result = this.config.hashCode();
            result = result * 31 + this.webViewData.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (!Intrinsics.areEqual((Object)this.config, (Object)params.config)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.webViewData, (Object)params.webViewData);
        }
    }
}

