/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar;

import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.scar.adapter.common.IScarAdapter;
import com.unity3d.scar.adapter.common.IScarInterstitialAdListenerWrapper;
import com.unity3d.scar.adapter.common.IScarRewardedAdListenerWrapper;
import com.unity3d.scar.adapter.common.WebViewAdsError;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.services.ads.gmascar.adapters.ScarAdapterFactory;
import com.unity3d.services.ads.gmascar.bridges.AdapterStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializationStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializeListenerBridge;
import com.unity3d.services.ads.gmascar.bridges.mobileads.MobileAdsBridgeBase;
import com.unity3d.services.ads.gmascar.finder.GMAInitializer;
import com.unity3d.services.ads.gmascar.finder.PresenceDetector;
import com.unity3d.services.ads.gmascar.finder.ScarAdapterVersion;
import com.unity3d.services.ads.gmascar.finder.ScarVersionFinder;
import com.unity3d.services.ads.gmascar.handlers.BiddingSignalsHandler;
import com.unity3d.services.ads.gmascar.handlers.ScarInterstitialAdHandler;
import com.unity3d.services.ads.gmascar.handlers.ScarRewardedAdHandler;
import com.unity3d.services.ads.gmascar.handlers.SignalsHandler;
import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.ads.gmascar.utils.GMAEventSender;
import com.unity3d.services.core.misc.EventSubject;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.timer.DefaultIntervalTimerFactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class GMAScarAdapterBridge {
    private final ScarVersionFinder _scarVersionFinder;
    private final MobileAdsBridgeBase _mobileAdsBridge;
    private final InitializeListenerBridge _initializationListenerBridge;
    private final InitializationStatusBridge _initializationStatusBridge;
    private final AdapterStatusBridge _adapterStatusBridge;
    private final PresenceDetector _presenceDetector;
    private final GMAInitializer _gmaInitializer;
    private final WebViewErrorHandler _webViewErrorHandler;
    private final ScarAdapterFactory _scarAdapterFactory;
    private final GMAEventSender _gmaEventSender;
    private IScarAdapter _scarAdapter;

    public GMAScarAdapterBridge(@Nullable MobileAdsBridgeBase mobileAdsBridge, InitializeListenerBridge initializeListenerBridge, InitializationStatusBridge initializationStatusBridge, AdapterStatusBridge adapterStatusBridge, WebViewErrorHandler webViewErrorHandler, ScarAdapterFactory adapterFactory, GMAEventSender eventSender) {
        this._initializationStatusBridge = initializationStatusBridge;
        this._initializationListenerBridge = initializeListenerBridge;
        this._adapterStatusBridge = adapterStatusBridge;
        this._webViewErrorHandler = webViewErrorHandler;
        this._scarAdapterFactory = adapterFactory;
        this._mobileAdsBridge = mobileAdsBridge;
        this._gmaEventSender = eventSender;
        this._presenceDetector = new PresenceDetector(this._mobileAdsBridge, this._initializationListenerBridge, this._initializationStatusBridge, this._adapterStatusBridge);
        this._gmaInitializer = new GMAInitializer(this._mobileAdsBridge, this._initializationListenerBridge, this._initializationStatusBridge, this._adapterStatusBridge, this._gmaEventSender);
        this._scarVersionFinder = new ScarVersionFinder(this._mobileAdsBridge, this._presenceDetector, this._gmaInitializer, this._gmaEventSender);
    }

    public void initializeScar() {
        if (this._presenceDetector.areGMAClassesPresent()) {
            this._gmaEventSender.send(GMAEvent.SCAR_PRESENT, new Object[0]);
            this._gmaInitializer.initializeGMA();
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)new GMAAdsError(GMAEvent.SCAR_NOT_PRESENT, new Object[0]));
        }
    }

    public boolean isInitialized() {
        return this._gmaInitializer.isInitialized();
    }

    public void getVersion() {
        this._scarVersionFinder.getVersion();
    }

    public void getSCARSignals(String[] interstitialList, String[] rewardedList) {
        this._scarAdapter = this.getScarAdapterObject();
        SignalsHandler signalListener = new SignalsHandler(this._gmaEventSender);
        if (this._scarAdapter != null) {
            this._scarAdapter.getSCARSignals(ClientProperties.getApplicationContext(), interstitialList, rewardedList, (ISignalCollectionListener)signalListener);
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalSignalsError((String)"Could not create SCAR adapter object"));
        }
    }

    public boolean hasSCARBiddingSupport() {
        if (this._mobileAdsBridge != null && this._mobileAdsBridge.hasSCARBiddingSupport()) {
            this._scarAdapter = this.getScarAdapterObject();
            return this._scarAdapter != null;
        }
        return false;
    }

    public void getSCARBiddingSignals(BiddingSignalsHandler handler) {
        if (this._mobileAdsBridge != null && this._mobileAdsBridge.hasSCARBiddingSupport()) {
            this._scarAdapter = this.getScarAdapterObject();
            if (this._scarAdapter != null) {
                this._scarAdapter.getSCARBiddingSignals(ClientProperties.getApplicationContext(), (ISignalCollectionListener)handler);
            } else {
                handler.onSignalsCollectionFailed("Could not create SCAR adapter object.");
            }
        } else {
            handler.onSignalsCollectionFailed("SCAR bidding unsupported.");
        }
    }

    public void load(boolean canSkip, String placementId, String queryId, String adString, String adUnitId, int videoLengthMs) {
        ScarAdMetadata scarAdMetadata = new ScarAdMetadata(placementId, queryId, adUnitId, adString, Integer.valueOf(videoLengthMs));
        this._scarAdapter = this.getScarAdapterObject();
        if (this._scarAdapter != null) {
            if (canSkip) {
                this.loadInterstitialAd(scarAdMetadata);
            } else {
                this.loadRewardedAd(scarAdMetadata);
            }
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalLoadError((ScarAdMetadata)scarAdMetadata, (String)"Scar Adapter object is null"));
        }
    }

    private void loadInterstitialAd(ScarAdMetadata scarAdMetadata) {
        ScarInterstitialAdHandler adListener = new ScarInterstitialAdHandler(scarAdMetadata, this.getScarEventSubject(scarAdMetadata.getVideoLengthMs()), this._gmaEventSender);
        this._scarAdapter.loadInterstitialAd(ClientProperties.getApplicationContext(), scarAdMetadata, (IScarInterstitialAdListenerWrapper)adListener);
    }

    private void loadRewardedAd(ScarAdMetadata scarAdMetadata) {
        ScarRewardedAdHandler adListener = new ScarRewardedAdHandler(scarAdMetadata, this.getScarEventSubject(scarAdMetadata.getVideoLengthMs()), this._gmaEventSender);
        this._scarAdapter.loadRewardedAd(ClientProperties.getApplicationContext(), scarAdMetadata, (IScarRewardedAdListenerWrapper)adListener);
    }

    public void show(String placementId, String queryId, boolean canSkip) {
        ScarAdMetadata scarAdMetadata = new ScarAdMetadata(placementId, queryId);
        this._scarAdapter = this.getScarAdapterObject();
        if (this._scarAdapter != null) {
            this._scarAdapter.show(ClientProperties.getActivity(), queryId, placementId);
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalShowError((ScarAdMetadata)scarAdMetadata, (String)"Scar Adapter object is null"));
        }
    }

    private EventSubject getScarEventSubject(Integer videoLengthMs) {
        return new EventSubject<GMAEvent>(new ArrayDeque<GMAEvent>(Arrays.asList(GMAEvent.FIRST_QUARTILE, GMAEvent.MIDPOINT, GMAEvent.THIRD_QUARTILE, GMAEvent.LAST_QUARTILE)), videoLengthMs, new DefaultIntervalTimerFactory());
    }

    private IScarAdapter getScarAdapterObject() {
        if (this._scarAdapter == null && this._mobileAdsBridge != null) {
            ScarAdapterVersion adapterVersion = this._mobileAdsBridge.getAdapterVersion(this._scarVersionFinder.getVersionCode());
            this._scarAdapter = this._scarAdapterFactory.createScarAdapter(adapterVersion, this._webViewErrorHandler);
        }
        return this._scarAdapter;
    }
}

