/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.NativeCallback;
import com.unity3d.services.core.webview.bridge.WebViewBridgeError;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONException;

public class WebViewBridge {
    private static HashMap<String, HashMap<String, HashMap<Integer, Method>>> _classTable;

    public static void setClassTable(Class[] apiClassList) {
        if (apiClassList == null) {
            return;
        }
        _classTable = new HashMap();
        for (Class cls : apiClassList) {
            if (cls == null || !cls.getPackage().getName().startsWith("com.unity3d.services") && !cls.getPackage().getName().startsWith("com.unity3d.ads.test")) continue;
            HashMap<String, HashMap> methodTable = new HashMap<String, HashMap>();
            for (Method method : cls.getMethods()) {
                if (method.getAnnotation(WebViewExposed.class) == null) continue;
                String methodName = method.getName();
                HashMap overrideTable = methodTable.containsKey(methodName) ? (HashMap)methodTable.get(methodName) : new HashMap();
                overrideTable.put(Arrays.deepHashCode(method.getParameterTypes()), method);
                methodTable.put(methodName, overrideTable);
            }
            _classTable.put(cls.getName(), methodTable);
        }
    }

    private static Method findMethod(String className, String methodName, Object[] parameters) throws JSONException, NoSuchMethodException {
        if (!_classTable.containsKey(className)) {
            throw new NoSuchMethodException();
        }
        HashMap<String, HashMap<Integer, Method>> methodTable = _classTable.get(className);
        if (!methodTable.containsKey(methodName)) {
            throw new NoSuchMethodException();
        }
        HashMap<Integer, Method> overrideTable = methodTable.get(methodName);
        Object[] types = WebViewBridge.getTypes(parameters);
        return overrideTable.get(Arrays.deepHashCode(types));
    }

    private static Class<?>[] getTypes(Object[] parameters) throws JSONException {
        Class[] types = parameters == null ? new Class[1] : new Class[parameters.length + 1];
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                types[i] = parameters[i].getClass();
            }
        }
        types[types.length - 1] = WebViewCallback.class;
        return types;
    }

    private static Object[] getValues(Object[] parameters, WebViewCallback callback) throws JSONException {
        Object[] values;
        if (parameters == null) {
            if (callback == null) {
                return null;
            }
            values = new Object[1];
        } else {
            values = new Object[parameters.length + (callback != null ? 1 : 0)];
        }
        if (parameters != null) {
            System.arraycopy(parameters, 0, values, 0, parameters.length);
        }
        if (callback != null) {
            values[values.length - 1] = callback;
        }
        return values;
    }

    public static void handleInvocation(String className, String methodName, Object[] parameters, WebViewCallback callback) throws Exception {
        Method method;
        try {
            method = WebViewBridge.findMethod(className, methodName, parameters);
        }
        catch (NoSuchMethodException | JSONException e) {
            callback.error(WebViewBridgeError.METHOD_NOT_FOUND, className, methodName, parameters);
            throw e;
        }
        try {
            Object[] values = WebViewBridge.getValues(parameters, callback);
            method.invoke(null, values);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException e) {
            if (callback != null) {
                callback.error(WebViewBridgeError.INVOCATION_FAILED, className, methodName, parameters, e.getMessage());
            }
            throw e;
        }
    }

    public static void handleCallback(String callbackId, String callbackStatus, Object[] parameters) throws Exception {
        NativeCallback callback = WebViewApp.getCurrentApp().getCallback(callbackId);
        try {
            callback.invoke(callbackStatus, WebViewBridge.getValues(parameters, null));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | JSONException e) {
            DeviceLog.error("Error while invoking method");
            throw e;
        }
    }
}

