/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.common;

import android.app.Activity;
import android.content.Context;
import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IScarAdapter;
import com.unity3d.scar.adapter.common.Utils;
import com.unity3d.scar.adapter.common.scarads.IScarAd;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.scar.adapter.common.signals.ISignalsCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ScarAdapterBase
implements IScarAdapter {
    protected ISignalsCollector _signalCollector;
    protected Map<String, IScarAd> _loadedAds = new ConcurrentHashMap<String, IScarAd>();
    protected IScarAd _currentAdReference;
    protected IAdsErrorHandler _adsErrorHandler;

    public ScarAdapterBase(IAdsErrorHandler adsErrorHandler) {
        this._adsErrorHandler = adsErrorHandler;
    }

    @Override
    public void getSCARBiddingSignals(Context context, ISignalCollectionListener signalCompletionListener) {
        this._signalCollector.getSCARBiddingSignals(context, signalCompletionListener);
    }

    @Override
    public void getSCARSignals(Context context, String[] interstitialList, String[] rewardedList, ISignalCollectionListener signalCompletionListener) {
        this._signalCollector.getSCARSignals(context, interstitialList, rewardedList, signalCompletionListener);
    }

    @Override
    public void show(final Activity activity, String queryId, String placementId) {
        IScarAd scarAd = this._loadedAds.get(placementId);
        if (scarAd == null) {
            this._adsErrorHandler.handleError(GMAAdsError.NoAdsError(placementId, queryId, "Could not find ad for placement '" + placementId + "'."));
        } else {
            this._currentAdReference = scarAd;
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ScarAdapterBase.this._currentAdReference.show(activity);
                }
            });
        }
    }
}

