/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitRequestType;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilder;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressor;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressorWithMetrics;
import com.unity3d.services.core.device.reader.DeviceInfoReaderPrivacyBuilder;
import com.unity3d.services.core.device.reader.GameSessionIdReader;
import com.unity3d.services.core.device.reader.IDeviceInfoDataContainer;

public class DeviceInfoDataFactory {
    public IDeviceInfoDataContainer getDeviceInfoData(InitRequestType callType) {
        switch (callType) {
            case TOKEN: {
                return this.getTokenDeviceInfoData();
            }
            case PRIVACY: {
                return this.getPrivacyDeviceInfoData();
            }
        }
        return null;
    }

    private IDeviceInfoDataContainer getPrivacyDeviceInfoData() {
        PrivacyConfigStorage privacyConfigStorage = PrivacyConfigStorage.getInstance();
        DeviceInfoReaderPrivacyBuilder deviceInfoReaderPrivacyBuilder = new DeviceInfoReaderPrivacyBuilder(new ConfigurationReader(), privacyConfigStorage, GameSessionIdReader.getInstance());
        return new DeviceInfoReaderCompressor(((DeviceInfoReaderBuilder)deviceInfoReaderPrivacyBuilder).build());
    }

    private IDeviceInfoDataContainer getTokenDeviceInfoData() {
        PrivacyConfigStorage privacyConfigStorage = PrivacyConfigStorage.getInstance();
        DeviceInfoReaderBuilder deviceInfoReaderBuilder = new DeviceInfoReaderBuilder(new ConfigurationReader(), privacyConfigStorage, GameSessionIdReader.getInstance());
        return new DeviceInfoReaderCompressorWithMetrics(new DeviceInfoReaderCompressor(deviceInfoReaderBuilder.build()));
    }
}

