/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.ads.token.NativeTokenGenerator;
import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilder;
import com.unity3d.services.core.device.reader.GameSessionIdReader;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;

public class TokenStorage {
    private static TokenStorage _instance;
    private final Object _lock = new Object();
    private ConcurrentLinkedQueue<String> _queue;
    private int _accessCounter = 0;
    private boolean _peekMode = false;
    private String _initToken = null;
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor();

    public static TokenStorage getInstance() {
        if (_instance == null) {
            _instance = new TokenStorage();
        }
        return _instance;
    }

    private TokenStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = this._lock;
        synchronized (object) {
            this._queue = new ConcurrentLinkedQueue();
            this._accessCounter = 0;
            for (int i = 0; i < tokens.length(); ++i) {
                this._queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !this._queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            this.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = this._lock;
        synchronized (object) {
            if (this._queue == null) {
                this._queue = new ConcurrentLinkedQueue();
                this._accessCounter = 0;
            }
            for (int i = 0; i < tokens.length(); ++i) {
                this._queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !this._queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            this.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTokens() {
        Object object = this._lock;
        synchronized (object) {
            this._queue = null;
            this._accessCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        Object object = this._lock;
        synchronized (object) {
            if (this._queue == null) {
                return this._initToken;
            }
            if (this._queue.isEmpty()) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
                return null;
            }
            if (this._peekMode) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, this._accessCounter++);
                return this._queue.peek();
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, this._accessCounter++);
            return this._queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeekMode(boolean mode) {
        Object object = this._lock;
        synchronized (object) {
            this._peekMode = mode;
        }
    }

    public void getNativeGeneratedToken() {
        NativeTokenGenerator nativeTokenGenerator = new NativeTokenGenerator(this._executorService, new DeviceInfoReaderBuilder(new ConfigurationReader(), PrivacyConfigStorage.getInstance(), GameSessionIdReader.getInstance()), null);
        nativeTokenGenerator.generateToken(new INativeTokenGeneratorListener(){

            @Override
            public void onReady(String token) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_NATIVE_DATA, token);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitToken(String value) {
        boolean shouldTriggerEvent;
        Object object = this._lock;
        synchronized (object) {
            this._initToken = value;
            shouldTriggerEvent = this._initToken != null;
        }
        if (shouldTriggerEvent) {
            this.triggerTokenAvailable(true);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    private void triggerTokenAvailable(Boolean withConfig) {
        InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(withConfig);
    }
}

