/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.IJsonStorageReader;
import com.unity3d.services.core.misc.Utilities;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonStorageAggregator
implements IJsonStorageReader {
    private final List<IJsonStorageReader> _jsonStorageReaders;

    public JsonStorageAggregator(List<IJsonStorageReader> jsonStorageReaders) {
        this._jsonStorageReaders = jsonStorageReaders;
    }

    @Override
    public JSONObject getData() {
        JSONObject mergedData = new JSONObject();
        for (IJsonStorageReader jsonStorageReader : this._jsonStorageReaders) {
            try {
                if (jsonStorageReader == null) continue;
                mergedData = Utilities.mergeJsonObjects(mergedData, jsonStorageReader.getData());
            }
            catch (JSONException e) {
                DeviceLog.error("Failed to merge storage: " + jsonStorageReader);
            }
        }
        return mergedData;
    }

    @Override
    public Object get(String key) {
        Object foundValue = null;
        for (IJsonStorageReader jsonStorageReader : this._jsonStorageReaders) {
            if (jsonStorageReader != null && (foundValue = jsonStorageReader.get(key)) != null) break;
        }
        return foundValue;
    }
}

