/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.configuration.IExperiments;
import com.unity3d.services.core.configuration.InitRequestType;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.device.reader.DeviceInfoReaderExtended;
import com.unity3d.services.core.device.reader.DeviceInfoReaderFilterProvider;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithFilter;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithLifecycle;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithMetrics;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithPII;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithPrivacy;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithRequestType;
import com.unity3d.services.core.device.reader.DeviceInfoReaderWithStorageInfo;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.device.reader.IGameSessionIdReader;
import com.unity3d.services.core.device.reader.MinimalDeviceInfoReader;
import com.unity3d.services.core.device.reader.pii.PiiDataProvider;
import com.unity3d.services.core.device.reader.pii.PiiDataSelector;
import com.unity3d.services.core.device.reader.pii.PiiTrackingStatusReader;
import com.unity3d.services.core.lifecycle.CachedLifecycle;
import com.unity3d.services.core.misc.JsonFlattenerRules;
import com.unity3d.services.core.misc.JsonStorageAggregator;
import java.util.Arrays;
import java.util.Collections;

public class DeviceInfoReaderBuilder {
    private final ConfigurationReader _configurationReader;
    private final PrivacyConfigStorage _privacyConfigStorage;
    private final IGameSessionIdReader _gameSessionIdReader;

    public DeviceInfoReaderBuilder(ConfigurationReader configurationReader, PrivacyConfigStorage privacyConfigStorage, IGameSessionIdReader gameSessionIdReader) {
        this._configurationReader = configurationReader;
        this._privacyConfigStorage = privacyConfigStorage;
        this._gameSessionIdReader = gameSessionIdReader;
    }

    public IDeviceInfoReader build() {
        IDeviceInfoReader deviceInfoReaderPrivacyDecorated;
        Storage privateStorage = StorageManager.getStorage(StorageManager.StorageType.PRIVATE);
        Storage publicStorage = StorageManager.getStorage(StorageManager.StorageType.PUBLIC);
        JsonStorageAggregator storageAggregator = new JsonStorageAggregator(Arrays.asList(publicStorage, privateStorage));
        DeviceInfoReaderFilterProvider deviceInfoReaderFilterProvider = new DeviceInfoReaderFilterProvider(privateStorage);
        DeviceInfoReaderWithLifecycle deviceInfoReaderWithLifecycle = new DeviceInfoReaderWithLifecycle(new DeviceInfoReaderExtended(this.buildWithRequestType(InitRequestType.TOKEN)), CachedLifecycle.getLifecycleListener());
        DeviceInfoReaderWithStorageInfo deviceInfoReaderWithStorageInfo = new DeviceInfoReaderWithStorageInfo(deviceInfoReaderWithLifecycle, this.getTsiRequestStorageRules(), privateStorage, publicStorage);
        PiiTrackingStatusReader piiTrackingStatusReader = new PiiTrackingStatusReader(storageAggregator);
        if (this._privacyConfigStorage != null && this.getCurrentExperiments().isPrivacyRequestEnabled()) {
            deviceInfoReaderPrivacyDecorated = new DeviceInfoReaderWithPrivacy(deviceInfoReaderWithStorageInfo, this._privacyConfigStorage, new PiiDataProvider(), piiTrackingStatusReader);
        } else {
            PiiDataSelector piiDataSelector = new PiiDataSelector(piiTrackingStatusReader, privateStorage, this.getCurrentExperiments());
            deviceInfoReaderPrivacyDecorated = new DeviceInfoReaderWithPII(deviceInfoReaderWithStorageInfo, piiDataSelector, new PiiDataProvider());
        }
        DeviceInfoReaderWithFilter deviceInfoReaderWithFilter = new DeviceInfoReaderWithFilter(deviceInfoReaderPrivacyDecorated, deviceInfoReaderFilterProvider.getFilterList());
        return new DeviceInfoReaderWithMetrics(deviceInfoReaderWithFilter);
    }

    protected IDeviceInfoReader buildWithRequestType(InitRequestType initRequestType) {
        return new DeviceInfoReaderWithRequestType(new MinimalDeviceInfoReader(this._gameSessionIdReader), initRequestType);
    }

    private IExperiments getCurrentExperiments() {
        if (this._configurationReader == null || this._configurationReader.getCurrentConfiguration() == null) {
            return new Experiments();
        }
        return this._configurationReader.getCurrentConfiguration().getExperiments();
    }

    private JsonFlattenerRules getTsiRequestStorageRules() {
        return new JsonFlattenerRules(Arrays.asList("privacy", "gdpr", "framework", "adapter", "mediation", "unity", "pipl", "configuration", "user", "unifiedconfig"), Collections.singletonList("value"), Arrays.asList("ts", "exclude", "pii", "nonBehavioral", "nonbehavioral"));
    }
}

