/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorInitializationBuffer;
import com.unity3d.services.ads.operation.load.LoadModuleDecoratorTimeout;
import com.unity3d.services.ads.operation.load.LoadOperation;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadModule
extends AdModule<ILoadOperation, LoadOperationState>
implements ILoadModule {
    private static ILoadModule _instance;
    private static final String errorMsgInternalCommunicationFailure = "[UnityAds] Internal communication failure";
    private static final String errorMsgInternalCommunicationTimeout = "[UnityAds] Internal communication timeout";
    private static final String errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";
    private static final String errorMsgFailedToCreateLoadRequest = "[UnityAds] Failed to create load request";

    public static ILoadModule getInstance() {
        if (_instance == null) {
            LoadModule loadModule = new LoadModule(SDKMetrics.getInstance());
            LoadModuleDecoratorInitializationBuffer bufferedLoadModule = new LoadModuleDecoratorInitializationBuffer(loadModule, InitializationNotificationCenter.getInstance());
            LoadModuleDecoratorTimeout timedLoadModule = new LoadModuleDecoratorTimeout(bufferedLoadModule, new ConfigurationReader());
            _instance = timedLoadModule;
        }
        return _instance;
    }

    public LoadModule(ISDKMetrics sdkMetrics) {
        super(sdkMetrics);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, final LoadOperationState state) {
        if (TextUtils.isEmpty((CharSequence)state.placementId)) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INVALID_ARGUMENT, errorMsgPlacementIdNull, true);
            return;
        }
        LoadOperation loadOperation = new LoadOperation(state, new WebViewBridgeInvocation(this._executorService, webViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(String message, CallbackStatus callbackStatus) {
                LoadModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(AdOperationError.callback_error, (Long)state.duration()));
                LoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, LoadModule.errorMsgInternalCommunicationFailure, false);
                LoadModule.this.remove(state.id);
            }

            @Override
            public void onTimeout() {
                LoadModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(AdOperationError.callback_timeout, (Long)state.duration()));
                LoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, LoadModule.errorMsgInternalCommunicationTimeout, false);
                LoadModule.this.remove(state.id);
            }
        }));
        JSONObject parameters = new JSONObject();
        JSONObject options = new JSONObject();
        try {
            options.put("headerBiddingOptions", (Object)state.loadOptions.getData());
            parameters.put("options", (Object)options);
            parameters.put("listenerId", (Object)loadOperation.getId());
            parameters.put("placementId", (Object)state.placementId);
            parameters.put("time", Device.getElapsedRealtime());
        }
        catch (JSONException e) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest, true);
            return;
        }
        catch (NullPointerException e) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest, true);
            return;
        }
        this.set(loadOperation);
        loadOperation.invoke(state.configuration.getWebViewBridgeTimeout(), parameters);
    }

    @Override
    public void onUnityAdsAdLoaded(String operationId) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        LoadOperationState state = loadOperation.getLoadOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadSuccess(state.duration()));
        loadOperation.onUnityAdsAdLoaded(state.placementId);
        this.remove(operationId);
    }

    @Override
    public void onUnityAdsFailedToLoad(String operationId, UnityAds.UnityAdsLoadError error, String message) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        LoadOperationState state = loadOperation.getLoadOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(error, (Long)state.duration()));
        loadOperation.onUnityAdsFailedToLoad(state.placementId, error, message);
        this.remove(operationId);
    }

    private void sendOnUnityAdsFailedToLoad(final LoadOperationState state, final UnityAds.UnityAdsLoadError error, final String message, boolean sendMetrics) {
        if (state == null || state.listener == null) {
            return;
        }
        if (sendMetrics) {
            this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(error, (Long)state.duration()));
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                state.onUnityAdsFailedToLoad(error, message);
            }
        });
    }
}

