/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.device.reader.IDeviceInfoDataCompressor;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.log.DeviceLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

public class DeviceInfoReaderCompressor
implements IDeviceInfoDataCompressor {
    private final IDeviceInfoReader _deviceInfoReader;

    public DeviceInfoReaderCompressor(IDeviceInfoReader deviceInfoReader) {
        this._deviceInfoReader = deviceInfoReader;
    }

    @Override
    public byte[] getDeviceData() {
        Map<String, Object> deviceDataMap = this.getDeviceInfo();
        return this.compressDeviceInfo(deviceDataMap);
    }

    @Override
    public Map<String, Object> getDeviceInfo() {
        return this._deviceInfoReader.getDeviceInfoData();
    }

    @Override
    public byte[] compressDeviceInfo(Map<String, Object> deviceData) {
        byte[] zippedData = null;
        if (deviceData != null) {
            JSONObject jsonData = new JSONObject(deviceData);
            String jsonString = jsonData.toString();
            ByteArrayOutputStream os = new ByteArrayOutputStream(jsonString.length());
            try {
                GZIPOutputStream gos = new GZIPOutputStream(os);
                gos.write(jsonString.getBytes());
                gos.flush();
                gos.close();
                os.close();
                zippedData = os.toByteArray();
            }
            catch (IOException e) {
                DeviceLog.error("Error occurred while trying to compress device data.");
            }
        } else {
            DeviceLog.error("Invalid DeviceInfoData: Expected non null map provided by reader");
        }
        return zippedData;
    }
}

