/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.lifecycle;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=14)
public class LifecycleCache
implements Application.ActivityLifecycleCallbacks {
    private LifecycleEvent _currentState = LifecycleEvent.RESUMED;
    private boolean _appActive = true;
    private Set<IAppActiveListener> _appActiveListeners = new HashSet<IAppActiveListener>();

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.CREATED;
    }

    public void onActivityStarted(Activity activity) {
        this._currentState = LifecycleEvent.STARTED;
    }

    public void onActivityResumed(Activity activity) {
        this._currentState = LifecycleEvent.RESUMED;
        this._appActive = true;
        this.notifyListeners();
    }

    public void onActivityPaused(Activity activity) {
        this._currentState = LifecycleEvent.PAUSED;
        this._appActive = false;
        this.notifyListeners();
    }

    public void onActivityStopped(Activity activity) {
        this._currentState = LifecycleEvent.STOPPED;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.SAVE_INSTANCE_STATE;
    }

    public void onActivityDestroyed(Activity activity) {
        this._currentState = LifecycleEvent.DESTROYED;
    }

    public LifecycleEvent getCurrentState() {
        return this._currentState;
    }

    public boolean isAppActive() {
        return this._appActive;
    }

    public synchronized void notifyListeners() {
        LifecycleEvent event = this._appActive ? LifecycleEvent.RESUMED : LifecycleEvent.PAUSED;
        for (IAppActiveListener listener : this._appActiveListeners) {
            listener.onAppStateChanged(event);
        }
    }

    public synchronized void addListener(IAppActiveListener listener) {
        this._appActiveListeners.add(listener);
    }

    public synchronized void removeListener(IAppActiveListener listener) {
        this._appActiveListeners.remove(listener);
    }
}

