/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.ads.token.NativeTokenGenerator;
import com.unity3d.services.ads.token.TokenEvent;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilder;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;

public class TokenStorage {
    private static final Object _lock = new Object();
    private static ConcurrentLinkedQueue<String> _queue;
    private static int _accessCounter;
    private static boolean _peekMode;
    private static String _initToken;
    private static ExecutorService _executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            _queue = new ConcurrentLinkedQueue();
            _accessCounter = 0;
            for (int i = 0; i < tokens.length(); ++i) {
                _queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !_queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            TokenStorage.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendTokens(JSONArray tokens) throws JSONException {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            if (_queue == null) {
                _queue = new ConcurrentLinkedQueue();
                _accessCounter = 0;
            }
            for (int i = 0; i < tokens.length(); ++i) {
                _queue.add(tokens.getString(i));
            }
            shouldTriggerEvent = !_queue.isEmpty();
        }
        if (shouldTriggerEvent) {
            TokenStorage.triggerTokenAvailable(false);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTokens() {
        Object object = _lock;
        synchronized (object) {
            _queue = null;
            _accessCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken() {
        Object object = _lock;
        synchronized (object) {
            if (_queue == null) {
                return _initToken;
            }
            if (_queue.isEmpty()) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.QUEUE_EMPTY, new Object[0]);
                return null;
            }
            if (_peekMode) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
                return _queue.peek();
            }
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_ACCESS, _accessCounter++);
            return _queue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPeekMode(boolean mode) {
        Object object = _lock;
        synchronized (object) {
            _peekMode = mode;
        }
    }

    public static void getNativeGeneratedToken() {
        NativeTokenGenerator nativeTokenGenerator = new NativeTokenGenerator(_executorService, new DeviceInfoReaderBuilder(new ConfigurationReader(), PrivacyConfigStorage.getInstance()), null);
        nativeTokenGenerator.generateToken(new INativeTokenGeneratorListener(){

            @Override
            public void onReady(String token) {
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.TOKEN, TokenEvent.TOKEN_NATIVE_DATA, token);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitToken(String value) {
        boolean shouldTriggerEvent;
        Object object = _lock;
        synchronized (object) {
            _initToken = value;
            shouldTriggerEvent = _initToken != null;
        }
        if (shouldTriggerEvent) {
            TokenStorage.triggerTokenAvailable(true);
            AsyncTokenStorage.getInstance().onTokenAvailable();
        }
    }

    private static void triggerTokenAvailable(Boolean withConfig) {
        InitializeEventsMetricSender.getInstance().sdkTokenDidBecomeAvailableWithConfig(withConfig);
    }

    static {
        _accessCounter = 0;
        _peekMode = false;
        _initToken = null;
        _executorService = Executors.newSingleThreadExecutor();
    }
}

