/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import android.os.Handler;
import android.os.Looper;
import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.services.ads.token.INativeTokenGenerator;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.ads.token.NativeTokenGenerator;
import com.unity3d.services.ads.token.NativeTokenGeneratorWithPrivacyAwait;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.TokenType;
import com.unity3d.services.core.device.reader.DeviceInfoReaderBuilder;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.InitializationStatusReader;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.metrics.ISDKMetrics;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncTokenStorage {
    private final List<TokenListenerState> _tokenListeners = new LinkedList<TokenListenerState>();
    private final Handler _handler;
    private boolean _tokenAvailable = false;
    private boolean _configurationWasSet = false;
    private Configuration _configuration = new Configuration();
    private INativeTokenGenerator _nativeTokenGenerator;
    private final InitializationStatusReader _initStatusReader = new InitializationStatusReader();
    private final ISDKMetrics _sdkMetrics;
    private static AsyncTokenStorage _instance;

    public static AsyncTokenStorage getInstance() {
        if (_instance == null) {
            _instance = new AsyncTokenStorage(null, new Handler(Looper.getMainLooper()), SDKMetrics.getInstance());
        }
        return _instance;
    }

    public AsyncTokenStorage(INativeTokenGenerator nativeTokenGenerator, Handler handler, ISDKMetrics sdkMetrics) {
        this._handler = handler;
        this._nativeTokenGenerator = nativeTokenGenerator;
        this._sdkMetrics = sdkMetrics;
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
        this._configurationWasSet = this.isValidConfig(this._configuration);
        if (!this._configurationWasSet) {
            return;
        }
        if (this._nativeTokenGenerator == null) {
            DeviceInfoReaderBuilder deviceInfoReaderBuilder = new DeviceInfoReaderBuilder(new ConfigurationReader(), PrivacyConfigStorage.getInstance());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            this._nativeTokenGenerator = new NativeTokenGenerator(executorService, deviceInfoReaderBuilder);
            if (configuration.getExperiments().shouldNativeTokenAwaitPrivacy()) {
                this._nativeTokenGenerator = new NativeTokenGeneratorWithPrivacyAwait(executorService, this._nativeTokenGenerator, configuration.getPrivacyRequestWaitTimeout());
            }
        }
        ArrayList<TokenListenerState> tempList = new ArrayList<TokenListenerState>(this._tokenListeners);
        for (TokenListenerState state : tempList) {
            this.handleTokenInvocation(state);
        }
    }

    public synchronized void onTokenAvailable() {
        this._tokenAvailable = true;
        if (!this._configurationWasSet) {
            return;
        }
        this.notifyListenersTokenReady();
    }

    public synchronized void getToken(IUnityAdsTokenListener listener) {
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.INITIALIZED_FAILED) {
            listener.onUnityAdsTokenReady(null);
            this.sendTokenMetrics(null, TokenType.TOKEN_REMOTE);
            return;
        }
        if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.NOT_INITIALIZED) {
            listener.onUnityAdsTokenReady(null);
            this.sendTokenMetrics(null, TokenType.TOKEN_REMOTE);
            return;
        }
        TokenListenerState state = this.addTimeoutHandler(listener);
        if (!this._configurationWasSet) {
            return;
        }
        this.handleTokenInvocation(state);
    }

    private synchronized TokenListenerState addTimeoutHandler(IUnityAdsTokenListener listener) {
        final TokenListenerState state = new TokenListenerState();
        state.listener = listener;
        state.tokenType = TokenType.TOKEN_REMOTE;
        state.runnable = new Runnable(){

            @Override
            public void run() {
                AsyncTokenStorage.this.notifyTokenReady(state, null);
            }
        };
        this._tokenListeners.add(state);
        this._handler.postDelayed(state.runnable, (long)this._configuration.getTokenTimeout());
        return state;
    }

    private synchronized void notifyListenersTokenReady() {
        String token;
        while (!this._tokenListeners.isEmpty() && (token = TokenStorage.getToken()) != null) {
            this.notifyTokenReady(this._tokenListeners.get(0), token);
        }
    }

    private void handleTokenInvocation(final TokenListenerState state) {
        if (state.invoked) {
            return;
        }
        state.invoked = true;
        if (!this._tokenAvailable && this._configuration.getExperiments().isNativeTokenEnabled()) {
            state.tokenType = TokenType.TOKEN_NATIVE;
            this._nativeTokenGenerator.generateToken(new INativeTokenGeneratorListener(){

                @Override
                public void onReady(final String token) {
                    AsyncTokenStorage.this._handler.post(new Runnable(){

                        @Override
                        public void run() {
                            AsyncTokenStorage.this.notifyTokenReady(state, token);
                        }
                    });
                }
            });
        } else {
            state.tokenType = TokenType.TOKEN_REMOTE;
            String token = TokenStorage.getToken();
            if (token == null || token.isEmpty()) {
                return;
            }
            this.notifyTokenReady(state, token);
        }
    }

    private synchronized void notifyTokenReady(TokenListenerState state, String token) {
        if (this._tokenListeners.remove(state)) {
            state.listener.onUnityAdsTokenReady(token);
            try {
                this._handler.removeCallbacks(state.runnable);
            }
            catch (Exception ex) {
                DeviceLog.exception("Failed to remove callback from a handler", ex);
            }
        }
        this.sendTokenMetrics(token, state.tokenType);
    }

    private void sendTokenMetrics(String token, TokenType type) {
        switch (type) {
            case TOKEN_NATIVE: {
                this.sendNativeTokenMetrics(token);
                break;
            }
            case TOKEN_REMOTE: {
                this.sendRemoteTokenMetrics(token);
                break;
            }
            default: {
                DeviceLog.error("Unknown token type passed to sendTokenMetrics");
            }
        }
    }

    private void sendNativeTokenMetrics(String token) {
        if (this._sdkMetrics == null) {
            return;
        }
        if (token == null) {
            this._sdkMetrics.sendMetric(TSIMetric.newNativeGeneratedTokenNull(this.getMetricTags()));
        } else {
            this._sdkMetrics.sendMetric(TSIMetric.newNativeGeneratedTokenAvailable(this.getMetricTags()));
        }
    }

    private void sendRemoteTokenMetrics(String token) {
        if (this._sdkMetrics == null) {
            return;
        }
        if (token == null || token.isEmpty()) {
            this._sdkMetrics.sendMetric(TSIMetric.newAsyncTokenNull(this.getMetricTags()));
        } else {
            this._sdkMetrics.sendMetric(TSIMetric.newAsyncTokenAvailable(this.getMetricTags()));
        }
    }

    private Map<String, String> getMetricTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("state", this._initStatusReader.getInitializationStateString(SdkProperties.getCurrentInitializationState()));
        return tags;
    }

    private boolean isValidConfig(Configuration configuration) {
        return configuration != null && configuration.getExperiments() != null;
    }

    class TokenListenerState {
        public IUnityAdsTokenListener listener;
        public Runnable runnable;
        public boolean invoked;
        public TokenType tokenType;

        TokenListenerState() {
        }
    }
}

