/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.lifecycle;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=14)
public class LifecycleCache
implements Application.ActivityLifecycleCallbacks {
    private LifecycleEvent _currentState = LifecycleEvent.RESUMED;
    private boolean _appActive = true;
    private Map<String, IAppActiveListener> _appActiveListeners = new ConcurrentHashMap<String, IAppActiveListener>();

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.CREATED;
    }

    public void onActivityStarted(Activity activity) {
        this._currentState = LifecycleEvent.STARTED;
    }

    public void onActivityResumed(Activity activity) {
        this._currentState = LifecycleEvent.RESUMED;
        this._appActive = true;
        if (this._appActiveListeners.containsKey(activity.getClass().getName())) {
            this.notifyListeners(activity.getClass().getName());
        }
    }

    public void onActivityPaused(Activity activity) {
        this._currentState = LifecycleEvent.PAUSED;
        this._appActive = false;
        if (this._appActiveListeners.containsKey(activity.getClass().getName())) {
            this.notifyListeners(activity.getClass().getName());
        }
    }

    public void onActivityStopped(Activity activity) {
        this._currentState = LifecycleEvent.STOPPED;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.SAVE_INSTANCE_STATE;
    }

    public void onActivityDestroyed(Activity activity) {
        this._currentState = LifecycleEvent.DESTROYED;
    }

    public LifecycleEvent getCurrentState() {
        return this._currentState;
    }

    public boolean isAppActive() {
        return this._appActive;
    }

    public void notifyListeners(String activityName) {
        if (this._appActiveListeners.get(activityName) != null) {
            LifecycleEvent event = this._appActive ? LifecycleEvent.RESUMED : LifecycleEvent.PAUSED;
            this._appActiveListeners.get(activityName).onAppStateChanged(event);
        }
    }

    public void addListener(String activityName, IAppActiveListener activeListener) {
        this._appActiveListeners.put(activityName, activeListener);
    }

    public void removeListener(String activityName) {
        this._appActiveListeners.remove(activityName);
    }
}

