/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.token;

import android.util.Base64;
import com.unity3d.services.ads.token.INativeTokenGenerator;
import com.unity3d.services.ads.token.INativeTokenGeneratorListener;
import com.unity3d.services.core.device.reader.DeviceInfoReaderCompressor;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.log.DeviceLog;
import java.util.concurrent.ExecutorService;

public class NativeTokenGenerator
implements INativeTokenGenerator {
    private ExecutorService _executorService;
    private IDeviceInfoReader _deviceInfoReader;

    public NativeTokenGenerator(ExecutorService executorService, IDeviceInfoReader deviceInfoReader) {
        this._executorService = executorService;
        this._deviceInfoReader = deviceInfoReader;
    }

    @Override
    public void generateToken(final INativeTokenGeneratorListener callback) {
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String queryData = Base64.encodeToString((byte[])new DeviceInfoReaderCompressor(NativeTokenGenerator.this._deviceInfoReader).getDeviceData(), (int)2);
                    StringBuilder stringBuilder = new StringBuilder(2 + queryData.length());
                    stringBuilder.append("1:");
                    stringBuilder.append(queryData);
                    callback.onReady(stringBuilder.toString());
                }
                catch (Exception e) {
                    DeviceLog.exception("Unity Ads failed to generate token.", e);
                    callback.onReady(null);
                }
            }
        });
    }
}

