/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.timer;

import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.LifecycleCache;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.timer.IIntervalTimer;
import com.unity3d.services.core.timer.IIntervalTimerListener;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class IntervalTimer
implements IIntervalTimer,
IAppActiveListener {
    private final String _timedActivityName;
    private final Integer _totalDurationMs;
    private final Integer _totalIntervals;
    private final Integer _intervalDuration;
    private IIntervalTimerListener _timerListener;
    private LifecycleCache _lifecycleCache;
    private Integer _nextInterval;
    private ScheduledExecutorService _timerService;
    private final AtomicBoolean _isRunning = new AtomicBoolean(false);
    private final AtomicBoolean _hasPaused = new AtomicBoolean(false);
    private final AtomicInteger _currentPosition = new AtomicInteger(0);
    private final Integer _delayMs = 1000;

    public IntervalTimer(String timedActivityName, Integer totalDurationMs, Integer totalIntervals, IIntervalTimerListener timerListener, LifecycleCache lifecycleCache) {
        this._timedActivityName = timedActivityName;
        this._totalDurationMs = totalDurationMs;
        this._totalIntervals = totalIntervals;
        this._timerListener = timerListener;
        this._lifecycleCache = lifecycleCache;
        this._nextInterval = this._intervalDuration = Integer.valueOf(this._totalIntervals == 0 ? this._totalDurationMs : this._totalDurationMs / this._totalIntervals);
        this._lifecycleCache.addListener(this._timedActivityName, this);
    }

    @Override
    public void start(ScheduledExecutorService timerService) {
        if (this._isRunning.compareAndSet(false, true)) {
            this._timerService = timerService;
            this.schedule();
        }
    }

    private void schedule() {
        try {
            this._timerService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    IntervalTimer.this.onNextMs();
                }
            }, this._delayMs.intValue(), this._delayMs.intValue(), TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException | RejectedExecutionException e) {
            DeviceLog.debug("ERROR: IntervalTimer failed to start due to exception " + e.getLocalizedMessage());
        }
    }

    public void onNextMs() {
        if (this._currentPosition.addAndGet(this._delayMs) >= this._nextInterval) {
            this.onNextInterval();
        }
    }

    @Override
    public void onNextInterval() {
        if (this._timerListener != null) {
            this._timerListener.onNextIntervalTriggered();
        }
        this.killIfCompleted();
        this._nextInterval = this._nextInterval + this._intervalDuration;
    }

    public void killIfCompleted() {
        if (this._nextInterval.compareTo(this._totalDurationMs) >= 0) {
            this.kill();
        }
    }

    public void stopTimer() {
        if (this._timerService != null && !this._timerService.isShutdown()) {
            this._timerService.shutdown();
        }
        this._isRunning.getAndSet(false);
    }

    @Override
    public void kill() {
        this.stopTimer();
        this._lifecycleCache.removeListener(this._timedActivityName);
        this._timerListener = null;
    }

    @Override
    public void onAppStateChanged(LifecycleEvent event) {
        switch (event) {
            case PAUSED: {
                this._hasPaused.getAndSet(true);
                this.stopTimer();
                break;
            }
            case RESUMED: {
                if (!this._hasPaused.get()) break;
                this._hasPaused.getAndSet(false);
                this.start(Executors.newSingleThreadScheduledExecutor());
                break;
            }
        }
    }
}

