/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader.pii;

import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.device.reader.pii.DataSelectorResult;
import com.unity3d.services.core.device.reader.pii.PiiDecisionData;
import com.unity3d.services.core.device.reader.pii.PiiTrackingStatusReader;
import com.unity3d.services.core.misc.IJsonStorageReader;
import com.unity3d.services.core.misc.Utilities;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PiiDataSelector {
    private final PiiTrackingStatusReader _piiTrackingStatusReader;
    private final IJsonStorageReader _jsonStorageReader;
    private final Experiments _experiments;

    public PiiDataSelector(PiiTrackingStatusReader piiTrackingStatusReader, IJsonStorageReader jsonStorageReader, Experiments experiments) {
        this._piiTrackingStatusReader = piiTrackingStatusReader;
        this._jsonStorageReader = jsonStorageReader;
        this._experiments = experiments;
    }

    public PiiDecisionData whatToDoWithPII() {
        switch (this._piiTrackingStatusReader.getPrivacyMode()) {
            case NONE: 
            case NULL: {
                return this.allowTrackingDecision();
            }
            case MIXED: {
                return this.mixedModeDecision();
            }
        }
        return this.notAllowedDecision();
    }

    private PiiDecisionData allowTrackingDecision() {
        return new PiiDecisionData(this._experiments.isUpdatePiiFields() ? DataSelectorResult.UPDATE : DataSelectorResult.INCLUDE, this.getPiiContentFromStorage());
    }

    private PiiDecisionData notAllowedDecision() {
        return new PiiDecisionData(DataSelectorResult.EXCLUDE);
    }

    private PiiDecisionData mixedModeDecision() {
        if (this._piiTrackingStatusReader.getUserNonBehavioralFlag()) {
            return new PiiDecisionData(DataSelectorResult.INCLUDE, this.getUserBehavioralAttribute());
        }
        PiiDecisionData mixedDecision = this.allowTrackingDecision();
        mixedDecision.appendData(this.getUserBehavioralAttribute());
        return mixedDecision;
    }

    private HashMap<String, Object> getUserBehavioralAttribute() {
        return new HashMap<String, Object>(){
            {
                this.put("user.nonBehavioral", PiiDataSelector.this._piiTrackingStatusReader.getUserNonBehavioralFlag());
            }
        };
    }

    private Map<String, Object> getPiiContentFromStorage() {
        Object piiData = this._jsonStorageReader.get("unifiedconfig.pii");
        Map<String, Object> piiDataMap = new HashMap<String, Object>();
        if (piiData instanceof JSONObject) {
            piiDataMap = Utilities.combineJsonIntoMap(piiDataMap, (JSONObject)piiData, "unifiedconfig.pii.");
        }
        return piiDataMap;
    }
}

