/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge;
import com.unity3d.services.store.gpbl.listeners.PurchasesResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PurchasesResponseListenerProxy
extends GenericListenerProxy {
    private static final String onQueryPurchasesResponseMethodName = "onQueryPurchasesResponse";
    private PurchasesResponseListener purchasesResponseListener;

    public PurchasesResponseListenerProxy(PurchasesResponseListener purchasesResponseListener) {
        this.purchasesResponseListener = purchasesResponseListener;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return PurchasesResponseListenerProxy.getProxyListenerClass();
    }

    public PurchasesResponseListener getPurchasesResponseListener() {
        return this.purchasesResponseListener;
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.PurchasesResponseListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result2 = null;
        if (m.getName().equals(onQueryPurchasesResponseMethodName)) {
            this.onQueryPurchasesResponse(args[0], (List)args[1]);
        } else {
            result2 = super.invoke(proxy, m, args);
        }
        return result2;
    }

    public void onQueryPurchasesResponse(Object billingResult, List<Object> purchases) {
        BillingResultBridge billingResultBridge = new BillingResultBridge(billingResult);
        ArrayList<PurchaseBridge> purchasesBridge = null;
        if (purchases != null) {
            purchasesBridge = new ArrayList<PurchaseBridge>();
            for (Object purchase : purchases) {
                purchasesBridge.add(new PurchaseBridge(purchase));
            }
        }
        if (this.purchasesResponseListener != null) {
            this.purchasesResponseListener.onPurchaseResponse(billingResultBridge, purchasesBridge);
        }
    }
}

