/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl;

import android.content.Context;
import com.unity3d.services.store.gpbl.BillingResultResponseCode;
import com.unity3d.services.store.gpbl.bridges.SkuDetailsParamsBridge;
import com.unity3d.services.store.gpbl.bridges.billingclient.BillingClientBuilderFactory;
import com.unity3d.services.store.gpbl.bridges.billingclient.IBillingClient;
import com.unity3d.services.store.gpbl.bridges.billingclient.IBillingClientBuilderBridge;
import com.unity3d.services.store.gpbl.listeners.BillingClientStateListener;
import com.unity3d.services.store.gpbl.listeners.PurchaseHistoryResponseListener;
import com.unity3d.services.store.gpbl.listeners.PurchaseUpdatedResponseListener;
import com.unity3d.services.store.gpbl.listeners.PurchasesResponseListener;
import com.unity3d.services.store.gpbl.listeners.SkuDetailsResponseListener;
import com.unity3d.services.store.gpbl.proxies.BillingClientStateListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchaseHistoryResponseListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchaseUpdatedListenerProxy;
import com.unity3d.services.store.gpbl.proxies.PurchasesResponseListenerProxy;
import com.unity3d.services.store.gpbl.proxies.SkuDetailsResponseListenerProxy;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class StoreBilling {
    private final IBillingClient _billingClientBridge;

    public StoreBilling(Context context, PurchaseUpdatedResponseListener purchaseUpdatedResponseListener) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        IBillingClientBuilderBridge builderBridge = BillingClientBuilderFactory.getBillingClientBuilder(context);
        builderBridge = builderBridge.setListener(new PurchaseUpdatedListenerProxy(purchaseUpdatedResponseListener));
        builderBridge = builderBridge.enablePendingPurchases();
        this._billingClientBridge = builderBridge.build();
    }

    public void initialize(BillingClientStateListener billingClientStateListener) throws ClassNotFoundException {
        this._billingClientBridge.startConnection(new BillingClientStateListenerProxy(billingClientStateListener));
    }

    public int isFeatureSupported(String purchaseType) {
        boolean featureSupported;
        String internalPurchaseType = purchaseType;
        if (internalPurchaseType.equals("inapp")) {
            featureSupported = this._billingClientBridge.isReady();
        } else {
            if (internalPurchaseType.equals("subs")) {
                internalPurchaseType = "subscriptions";
            }
            featureSupported = this._billingClientBridge.isFeatureSupported(internalPurchaseType) == BillingResultResponseCode.OK;
        }
        return featureSupported ? 0 : -1;
    }

    public void getPurchases(String purchaseType, PurchasesResponseListener purchasesResponseListener) throws ClassNotFoundException {
        this._billingClientBridge.queryPurchasesAsync(purchaseType, new PurchasesResponseListenerProxy(purchasesResponseListener));
    }

    public void getSkuDetails(String purchaseType, List<String> skuList, SkuDetailsResponseListener skuDetailsResponseListener) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SkuDetailsParamsBridge.BuilderBridge skuDetailsParamsBuilderBridge = SkuDetailsParamsBridge.newBuilder();
        SkuDetailsParamsBridge skuDetailsParamsBridge = skuDetailsParamsBuilderBridge.setSkuList(skuList).setType(purchaseType).build();
        this._billingClientBridge.querySkuDetailsAsync(skuDetailsParamsBridge, new SkuDetailsResponseListenerProxy(skuDetailsResponseListener));
    }

    public void getPurchaseHistory(String purchaseType, int maxPurchases, PurchaseHistoryResponseListener purchaseHistoryResponseListener) throws ClassNotFoundException {
        this._billingClientBridge.queryPurchaseHistoryAsync(purchaseType, new PurchaseHistoryResponseListenerProxy(purchaseHistoryResponseListener, maxPurchases));
    }
}

