/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl;

import androidx.annotation.NonNull;

public enum BillingResultResponseCode {
    UNKNOWN(-100),
    SERVICE_TIMEOUT(-3),
    FEATURE_NOT_SUPPORTED(-2),
    SERVICE_DISCONNECTED(-1),
    OK(0),
    USER_CANCELED(1),
    SERVICE_UNAVAILABLE(2),
    BILLING_UNAVAILABLE(3),
    ITEM_UNAVAILABLE(4),
    DEVELOPER_ERROR(5),
    ERROR(6),
    ITEM_ALREADY_OWNED(7),
    ITEM_NOT_OWNED(8),
    NETWORK_ERROR(12);

    private final int _responseCode;

    private BillingResultResponseCode(int responseCode) {
        this._responseCode = responseCode;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    @NonNull
    public static BillingResultResponseCode fromResponseCode(int responseCode) {
        for (BillingResultResponseCode billingResultResponseCode : BillingResultResponseCode.values()) {
            if (billingResultResponseCode.getResponseCode() != responseCode) continue;
            return billingResultResponseCode;
        }
        return UNKNOWN;
    }
}

