/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import com.unity3d.services.core.misc.IEventListener;
import com.unity3d.services.core.timer.IIntervalTimer;
import com.unity3d.services.core.timer.IIntervalTimerFactory;
import com.unity3d.services.core.timer.IIntervalTimerListener;
import java.util.Queue;
import java.util.concurrent.Executors;

public class EventSubject<T> {
    IIntervalTimer _intervalTimer;
    Queue<T> _eventQueue;
    private IEventListener<T> _eventListener;

    public EventSubject(Queue<T> eventQueue, Integer durationMs, IIntervalTimerFactory timerFactory) {
        this._eventQueue = eventQueue;
        this._intervalTimer = timerFactory.createTimer(durationMs, eventQueue.size(), new IIntervalTimerListener(){

            @Override
            public void onNextIntervalTriggered() {
                EventSubject.this.sendNextEvent();
            }
        });
    }

    public void sendNextEvent() {
        if (this._eventListener != null) {
            this._eventListener.onNextEvent(this._eventQueue.remove());
        }
        if (this._eventQueue.size() <= 0) {
            this.unsubscribe();
        }
    }

    public void subscribe(IEventListener<T> eventListener) {
        if (this._eventQueue == null || this._eventQueue.size() <= 0 || this._intervalTimer == null || eventListener == null) {
            return;
        }
        this._eventListener = eventListener;
        this.startTimer();
    }

    private void startTimer() {
        if (this._intervalTimer != null) {
            this._intervalTimer.start(Executors.newSingleThreadScheduledExecutor());
        }
    }

    private void killTimer() {
        if (this._intervalTimer != null) {
            this._intervalTimer.kill();
            this._intervalTimer = null;
        }
    }

    public void unsubscribe() {
        this.killTimer();
        this._eventListener = null;
    }

    public boolean eventQueueIsEmpty() {
        return this._eventQueue.isEmpty();
    }
}

