/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.reader.IDeviceInfoReader;
import com.unity3d.services.core.device.reader.pii.PiiDataProvider;
import com.unity3d.services.core.device.reader.pii.PiiTrackingStatusReader;
import java.util.HashMap;
import java.util.Map;

public class DeviceInfoReaderWithPrivacy
implements IDeviceInfoReader {
    private final IDeviceInfoReader _deviceInfoReader;
    private final PrivacyConfigStorage _privacyConfigStorage;
    private final PiiDataProvider _piiDataProvider;
    private final PiiTrackingStatusReader _piiTrackingStatusReader;

    public DeviceInfoReaderWithPrivacy(IDeviceInfoReader deviceInfoReader, PrivacyConfigStorage privacyConfigStorage, PiiDataProvider piiDataProvider, PiiTrackingStatusReader piiTrackingStatusReader) {
        this._deviceInfoReader = deviceInfoReader;
        this._privacyConfigStorage = privacyConfigStorage;
        this._piiDataProvider = piiDataProvider;
        this._piiTrackingStatusReader = piiTrackingStatusReader;
    }

    @Override
    public Map<String, Object> getDeviceInfoData() {
        Map<String, Object> originalData = this._deviceInfoReader.getDeviceInfoData();
        if (this._privacyConfigStorage != null && this._privacyConfigStorage.getPrivacyConfig() != null) {
            if (this._privacyConfigStorage.getPrivacyConfig().allowedToSendPii()) {
                originalData.putAll(this.getPiiAttributesFromDevice());
            }
            if (this._privacyConfigStorage.getPrivacyConfig().shouldSendNonBehavioral()) {
                originalData.put("user.nonBehavioral", this._piiTrackingStatusReader.getUserNonBehavioralFlag());
            }
        }
        return originalData;
    }

    private Map<String, Object> getPiiAttributesFromDevice() {
        HashMap<String, Object> piiData = new HashMap<String, Object>();
        String advertisingId = this._piiDataProvider.getAdvertisingTrackingId();
        if (advertisingId != null) {
            piiData.put("unifiedconfig.pii.advertisingTrackingId", advertisingId);
        }
        return piiData;
    }
}

