/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.configuration.IExperiments;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import org.json.JSONException;
import org.json.JSONObject;

public class ExperimentsReader {
    private IExperiments _localExperiments;
    private IExperiments _remoteExperiments;

    public synchronized void updateLocalExperiments(IExperiments localExperiments) {
        this._localExperiments = localExperiments;
    }

    public synchronized void updateRemoteExperiments(IExperiments remoteExperiments) {
        this._remoteExperiments = remoteExperiments;
    }

    public synchronized IExperiments getCurrentlyActiveExperiments() {
        if (this._remoteExperiments == null && this._localExperiments == null) {
            return new Experiments();
        }
        if (this._remoteExperiments == null) {
            return this._localExperiments;
        }
        if (this._localExperiments == null) {
            this._localExperiments = new Experiments();
        }
        JSONObject localActiveExp = this._localExperiments.getNextSessionExperiments();
        JSONObject remoteActiveExp = this._remoteExperiments.getCurrentSessionExperiments();
        try {
            return new Experiments(Utilities.mergeJsonObjects(localActiveExp, remoteActiveExp));
        }
        catch (JSONException e) {
            DeviceLog.error("Couldn't get active experiments, reverting to default experiments");
            return new Experiments();
        }
    }
}

