package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class QueryProductDetailsResultsBridge(private val productDetailsResult: Any) : GenericBridge(
    mapOf(GET_PRODUCT_DETAILS_LIST_METHOD to emptyArray<Class<*>>())
) {

    fun getProductDetailsList(): List<ProductDetailsBridge> {
        val productDetailsList = callNonVoidMethod(GET_PRODUCT_DETAILS_LIST_METHOD, productDetailsResult) as List<Any>?
        return productDetailsList?.map { ProductDetailsBridge(it) } ?: emptyList()
    }

    override fun getClassName(): String {
        return "com.android.billingclient.api.QueryProductDetailsResult"
    }

    companion object {
        private const val GET_PRODUCT_DETAILS_LIST_METHOD = "getProductDetailsList"
    }
}
