@file:JvmName("AdFormatExtensions")
package com.unity3d.ads.core.extensions

import com.unity3d.scar.adapter.common.scarads.UnityAdFormat
import gatewayprotocol.v1.AdFormatOuterClass.AdFormat

fun AdFormat.toUnityAdFormat(): UnityAdFormat? {
    return when(this) {
        AdFormat.AD_FORMAT_REWARDED -> UnityAdFormat.REWARDED
        AdFormat.AD_FORMAT_INTERSTITIAL -> UnityAdFormat.INTERSTITIAL
        AdFormat.AD_FORMAT_BANNER -> UnityAdFormat.BANNER
        AdFormat.AD_FORMAT_UNSPECIFIED -> UnityAdFormat.UNSPECIFIED
        else -> null
    }
}

fun com.unity3d.ads.AdFormat.toProtoAdFormat(): AdFormat {
    return when (this) {
        com.unity3d.ads.AdFormat.UNSPECIFIED -> AdFormat.AD_FORMAT_UNSPECIFIED
        com.unity3d.ads.AdFormat.BANNER -> AdFormat.AD_FORMAT_BANNER
        com.unity3d.ads.AdFormat.INTERSTITIAL -> AdFormat.AD_FORMAT_INTERSTITIAL
        com.unity3d.ads.AdFormat.REWARDED -> AdFormat.AD_FORMAT_REWARDED
    }
}

fun com.unity3d.ads.AdFormat.toUnityAdFormat(): UnityAdFormat {
    return when (this) {
        com.unity3d.ads.AdFormat.UNSPECIFIED -> UnityAdFormat.UNSPECIFIED
        com.unity3d.ads.AdFormat.BANNER -> UnityAdFormat.BANNER
        com.unity3d.ads.AdFormat.INTERSTITIAL -> UnityAdFormat.INTERSTITIAL
        com.unity3d.ads.AdFormat.REWARDED -> UnityAdFormat.REWARDED
    }
}