package com.unity3d.ads.core.domain.work

import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock
import java.util.PriorityQueue

class DownloadPriorityQueue {
    private val mutex = Mutex(false)
    private val nextTurn = MutableStateFlow<PriorityItem?>(null)
    private val queue = PriorityQueue<PriorityItem>(50, compareBy { it.priority })

    /**
     * Registers an action to the queue.
     * 0 is the highest priority.
     */
    suspend operator fun invoke(priority: Int, downloadAction: suspend () -> Unit) {
        val priorityItem = PriorityItem(priority)

        // Register to queue
        mutex.withLock {
            queue.offer(priorityItem)
            nextTurn.value = queue.peek()
        }

        // Wait for turn
        nextTurn.first { it === priorityItem }

        // Run action
        downloadAction()

        // Leave queue
        mutex.withLock {
            queue.remove(priorityItem)
            nextTurn.value = queue.peek()
        }
    }

    class PriorityItem(val priority: Int)
}