package com.unity3d.ads.core.domain.work

import android.content.Context
import androidx.work.Constraints
import androidx.work.NetworkType
import androidx.work.OneTimeWorkRequestBuilder
import androidx.work.WorkManager


/**
 * This class is responsible for scheduling the [UniversalRequestJob] to run.
 * We run the job only when network is connected using an exponential backoff policy with 30 seconds as the minimum delay. (default settings for a work request)
 * When the application starts, it will try to run any jobs that have not finished successfully.
 */

class BackgroundWorker(applicationContext: Context) {
    val workManager = WorkManager.getInstance(applicationContext)

    inline operator fun <reified T : UniversalRequestJob> invoke(universalRequestWorkerData: UniversalRequestWorkerData) {
        val workRequest = OneTimeWorkRequestBuilder<T>()
            .setInputData(universalRequestWorkerData())
            .addTag(TAG)
            .build()
        workManager.enqueue(workRequest)
    }

    companion object {
        const val TAG = "UnityAdsBackgroundWorker"
    }
}