package com.unity3d.ads.core.domain

import android.webkit.WebView
import com.unity3d.ads.core.log.LogLevel
import com.unity3d.ads.core.log.Logger
import gatewayprotocol.v1.NativeConfigurationOuterClass.DebugSettings

internal class HandleDebugSettings(
    private val logger: Logger,
) {
    operator fun invoke(debugSettings: DebugSettings) {
        if (debugSettings.enableTracing) {
            logger.logLevel = LogLevel.TRACE
        }

        WebView.setWebContentsDebuggingEnabled(debugSettings.webviewInspectable)
    }
}