package com.unity3d.ads.core.domain

import com.unity3d.ads.core.configuration.AndroidManifestIntPropertyReader
import gatewayprotocol.v1.testData

class AndroidTestDataInfo(
    private val androidManifestIntPropertyReader: AndroidManifestIntPropertyReader
) : GetTestDataInfo {
    override operator fun invoke(): gatewayprotocol.v1.TestDataOuterClass.TestData? {
        return testData {
            androidManifestIntPropertyReader.getPropertyByName(EXCHANGE_TEST_MODE)?.let { forceExchangeTestMode = it }
        }.takeIf { it.hasForceExchangeTestMode() }
    }

    companion object {
        const val EXCHANGE_TEST_MODE = "ExchangeTestMode"
    }
}