package com.unity3d.ads.core.domain

import android.content.Intent
import androidx.core.net.toUri

class AndroidIntentCreation : IntentCreation {
    override fun invoke(
        url: String,
        packageName: String?,
        action: String?,
        extras: Map<String, Any?>?,
    ): Intent {
        return Intent().apply {
            packageName?.takeIf(String::isNotEmpty)?.let(::setPackage)
            action?.takeIf(String::isNotEmpty)?.let(::setAction)
            data = url.toUri()
            extras?.forEach { (key, value) ->
                when (value) {
                    is String -> putExtra(key, value)
                    is Int -> putExtra(key, value)
                    is Boolean -> putExtra(key, value)
                    is Float -> putExtra(key, value)
                    is Double -> putExtra(key, value)
                }
            }
        }
    }
}