package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.gatewayclient.RequestPolicy


internal class AndroidGetAdRequestPolicy(private val sessionRepository: SessionRepository): GetRequestPolicy {
    override fun invoke(): RequestPolicy {
        return RequestPolicy(
            maxDuration = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.maxDuration,
            retryMaxInterval = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryMaxInterval,
            retryWaitBase = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryWaitBase,
            retryJitterPct = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryJitterPct,
            retryScalingFactor = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.retryScalingFactor,
            connectTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.connectTimeoutMs,
            readTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.readTimeoutMs,
            writeTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.writeTimeoutMs,
            overallTimeout = sessionRepository.nativeConfiguration.adPolicy.timeoutPolicy.overallTimeoutMs,
            shouldStoreLocally = sessionRepository.nativeConfiguration.adPolicy.retryPolicy.shouldStoreLocally
        )
    }
}