package com.unity3d.services.store.gpbl.bridges.billingclient.v6;

import android.content.Context;

import com.unity3d.services.store.gpbl.bridges.SkuDetailsParamsBridge;
import com.unity3d.services.store.gpbl.bridges.billingclient.common.BillingClientBridgeCommon;
import com.unity3d.services.store.gpbl.proxies.PurchasesResponseListenerProxy;
import com.unity3d.services.store.gpbl.proxies.SkuDetailsResponseListenerProxy;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class BillingClientBridge extends BillingClientBridgeCommon {

	private static final String queryPurchasesAsyncMethodName = "queryPurchasesAsync";
	private static final String querySkuDetailsAsyncMethodName = "querySkuDetailsAsync";


	public BillingClientBridge(Object billingClientInternalInstance) throws ClassNotFoundException {
		super(billingClientInternalInstance, new HashMap<String, Class<?>[]>() {{
			put(querySkuDetailsAsyncMethodName, new Class[]{SkuDetailsParamsBridge.getClassForBridge(), SkuDetailsResponseListenerProxy.getProxyListenerClass()});
			put(queryPurchasesAsyncMethodName, new Class[]{String.class, PurchasesResponseListenerProxy.getProxyListenerClass()});
		}});
	}

	@Override
	public void queryPurchasesAsync(String purchaseType, PurchasesResponseListenerProxy purchasesResponseListenerProxy) throws ClassNotFoundException {
		callVoidMethod(queryPurchasesAsyncMethodName, _billingClientInternalInstance, purchaseType, purchasesResponseListenerProxy.getProxyInstance());
	}

	@Override
	public void querySkuDetailsAsync(SkuDetailsParamsBridge params, SkuDetailsResponseListenerProxy skuDetailsResponseListenerProxy) throws ClassNotFoundException {
		callVoidMethod(querySkuDetailsAsyncMethodName, _billingClientInternalInstance, params.getInternalInstance(), skuDetailsResponseListenerProxy.getProxyInstance());
	}

	public static BillingClientBuilderBridge newBuilder(Context context) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
		Object billingClientBuilderInternalInstance = callNonVoidStaticMethod(newBuilderMethodName, context);
		return new BillingClientBuilderBridge(billingClientBuilderInternalInstance);
	}
}
