package com.unity3d.ads.core.data.repository

import android.content.Context
import android.webkit.WebView
import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.OMResult
import com.unity3d.ads.core.data.model.OMData
import com.unity3d.ads.core.data.model.OmidOptions

interface OpenMeasurementRepository {
    val omData: OMData
    var isOMActive: Boolean
    suspend fun activateOM(context: Context): OMResult
    suspend fun startSession(opportunityId: ByteString, webView: WebView?, options: OmidOptions): OMResult
    suspend fun finishSession(opportunityId: ByteString): OMResult
    suspend fun impressionOccurred(opportunityId: ByteString, signalLoaded: Boolean): OMResult
    fun hasSessionFinished(opportunityId: ByteString): Boolean
}