package com.unity3d.ads.core.data.datasource

import android.content.Context
import com.google.android.gms.appset.AppSet
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.getAndUpdate


/**
 * DataSource class that provides the appSetId. It subscribes to the AppSetIdManager and retrieves
 * the value async.
 */
class AndroidAppSetIdDataSource(
    private val applicationContext: Context
) {
    private val isCollecting: MutableStateFlow<Boolean> = MutableStateFlow(false)

    private val _appSetIdFlow: MutableStateFlow<String?> = MutableStateFlow(null)
    val appSetId: String?
        get() = _appSetIdFlow.value

    operator fun invoke() {
        if (isCollecting.getAndUpdate { true }) return // already collecting id

        try {
            AppSet.getClient(applicationContext).appSetIdInfo.addOnSuccessListener {
                val appSetId = it.id
                _appSetIdFlow.value = appSetId
            }
        } catch (ignore: Throwable) {
        }
    }
}