package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class PendingPurchasesParamsBridge(private val pendingPurchasesParamsInternalInstance: Any?) : GenericBridge(hashMapOf(
    NEW_BUILDER_METHOD_NAME to emptyArray<Class<*>>()
))
    {
    override fun getClassName(): String {
        return "com.android.billingclient.api.PendingPurchasesParams"
    }

    fun getInternalClass(): Any? {
        return pendingPurchasesParamsInternalInstance
    }

    companion object {
        fun getClassForParams(): Class<*> {
            return Class.forName("com.android.billingclient.api.PendingPurchasesParams")
        }

        const val NEW_BUILDER_METHOD_NAME = "newBuilder"

        fun newBuilder(): PendingPurchasesParamsBuilderBridge {
            val billingClientBuilderInternalInstance = callNonVoidStaticMethod(NEW_BUILDER_METHOD_NAME)
            return PendingPurchasesParamsBuilderBridge(billingClientBuilderInternalInstance)
        }

        private fun callNonVoidStaticMethod(methodName: String): Any {
            val method = getClassForParams().getMethod(methodName)
            return method.invoke(null) ?: throw IllegalStateException("Static method $methodName returned null")
        }
    }
}