/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.common.signals;

import android.content.Context;
import com.unity3d.scar.adapter.common.DispatchGroup;
import com.unity3d.scar.adapter.common.scarads.UnityAdFormat;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.scar.adapter.common.signals.ISignalsCollector;
import com.unity3d.scar.adapter.common.signals.SignalsResult;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public abstract class SignalsCollectorBase
implements ISignalsCollector {
    public static final String SCAR_RV_SIGNAL = "gmaScarBiddingRewardedSignal";
    public static final String SCAR_INT_SIGNAL = "gmaScarBiddingInterstitialSignal";
    public static final String SCAR_BAN_SIGNAL = "gmaScarBiddingBannerSignal";

    @Override
    public void getSCARSignal(Context context, String placementId, UnityAdFormat adFormat, ISignalCollectionListener signalCompletionListener) {
        DispatchGroup dispatchGroup = new DispatchGroup();
        SignalsResult signalsResult = new SignalsResult();
        dispatchGroup.enter();
        this.getSCARSignal(context, placementId, adFormat, dispatchGroup, signalsResult);
        dispatchGroup.notify(new GMAScarDispatchCompleted(signalCompletionListener, signalsResult));
    }

    @Override
    public void getSCARBiddingSignals(Context context, List<UnityAdFormat> adFormats, ISignalCollectionListener signalCompletionListener) {
        DispatchGroup dispatchGroup = new DispatchGroup();
        SignalsResult signalsResult = new SignalsResult();
        for (UnityAdFormat adFormat : adFormats) {
            dispatchGroup.enter();
            this.getSCARSignalForHB(context, adFormat, dispatchGroup, signalsResult);
        }
        dispatchGroup.notify(new GMAScarDispatchCompleted(signalCompletionListener, signalsResult));
    }

    @Override
    public void getSCARBiddingSignals(Context context, boolean isBannerEnabled, ISignalCollectionListener signalCompletionListener) {
        DispatchGroup dispatchGroup = new DispatchGroup();
        SignalsResult signalsResult = new SignalsResult();
        dispatchGroup.enter();
        this.getSCARSignalForHB(context, UnityAdFormat.INTERSTITIAL, dispatchGroup, signalsResult);
        dispatchGroup.enter();
        this.getSCARSignalForHB(context, UnityAdFormat.REWARDED, dispatchGroup, signalsResult);
        if (isBannerEnabled) {
            dispatchGroup.enter();
            this.getSCARSignalForHB(context, UnityAdFormat.BANNER, dispatchGroup, signalsResult);
        }
        dispatchGroup.notify(new GMAScarDispatchCompleted(signalCompletionListener, signalsResult));
    }

    public void onOperationNotSupported(String msg, DispatchGroup dispatchGroup, SignalsResult signalsResult) {
        signalsResult.setErrorMessage(String.format("Operation Not supported: %s.", msg));
        dispatchGroup.leave();
    }

    public String getAdKey(UnityAdFormat adFormat) {
        switch (adFormat) {
            case BANNER: {
                return SCAR_BAN_SIGNAL;
            }
            case INTERSTITIAL: {
                return SCAR_INT_SIGNAL;
            }
            case REWARDED: {
                return SCAR_RV_SIGNAL;
            }
        }
        return "";
    }

    private class GMAScarDispatchCompleted
    implements Runnable {
        private ISignalCollectionListener _signalListener;
        private SignalsResult _signalsResult;

        public GMAScarDispatchCompleted(ISignalCollectionListener signalListener, SignalsResult signalsResult) {
            this._signalListener = signalListener;
            this._signalsResult = signalsResult;
        }

        @Override
        public void run() {
            Map<String, String> signalsMap = this._signalsResult.getSignalsMap();
            if (signalsMap.size() > 0) {
                JSONObject placementJSON = new JSONObject(signalsMap);
                this._signalListener.onSignalsCollected(placementJSON.toString());
            } else if (this._signalsResult.getErrorMessage() == null) {
                this._signalListener.onSignalsCollected("");
            } else {
                this._signalListener.onSignalsCollectionFailed(this._signalsResult.getErrorMessage());
            }
        }
    }
}

